/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import koala.dynamicjava.interpreter.error.WrongVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TigerUtilities {
    public static final int BRIDGE = 64;
    public static final int VARARGS = 128;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final float VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static boolean _tigerEnabled;

    public static void resetVersion() {
        _tigerEnabled = (double)VERSION > 1.49;
    }

    public static boolean isTigerEnabled() {
        return _tigerEnabled;
    }

    public static void setTigerEnabled(boolean enabled) {
        _tigerEnabled = enabled;
    }

    public static void assertTigerEnabled(String msg) {
        if (!_tigerEnabled) {
            throw new WrongVersionException(msg);
        }
    }

    public static boolean isVarArgs(Method m) {
        return _tigerEnabled && (m.getModifiers() & 0x80) != 0;
    }

    public static boolean isVarArgs(Constructor c) {
        return _tigerEnabled && (c.getModifiers() & 0x80) != 0;
    }

    public static boolean isBridge(Method m) {
        return _tigerEnabled && (m.getModifiers() & 0x40) != 0;
    }

    public static boolean isEnum(Class<?> c) {
        try {
            return _tigerEnabled && c.getSuperclass() != null && c.getSuperclass().equals(Class.forName("java.lang.Enum"));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isEnumConstant(Field f) {
        return _tigerEnabled && (f.getModifiers() & 0x4000) != 0;
    }

    public static Class<?> correspondingBoxingType(Class<?> primType) {
        if (primType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primType == Byte.TYPE) {
            return Byte.class;
        }
        if (primType == Character.TYPE) {
            return Character.class;
        }
        if (primType == Short.TYPE) {
            return Short.class;
        }
        if (primType == Integer.TYPE) {
            return Integer.class;
        }
        if (primType == Long.TYPE) {
            return Long.class;
        }
        if (primType == Float.TYPE) {
            return Float.class;
        }
        if (primType == Double.TYPE) {
            return Double.class;
        }
        return primType;
    }

    public static Class<?> correspondingPrimType(Class<?> refType) {
        if (refType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (refType == Byte.class) {
            return Byte.TYPE;
        }
        if (refType == Character.class) {
            return Character.TYPE;
        }
        if (refType == Short.class) {
            return Short.TYPE;
        }
        if (refType == Integer.class) {
            return Integer.TYPE;
        }
        if (refType == Long.class) {
            return Long.TYPE;
        }
        if (refType == Float.class) {
            return Float.TYPE;
        }
        if (refType == Double.class) {
            return Double.TYPE;
        }
        return refType;
    }

    public static boolean isBoxingType(Class<?> c) {
        return c == Integer.class || c == Long.class || c == Boolean.class || c == Double.class || c == Character.class || c == Short.class || c == Byte.class || c == Float.class;
    }

    public static boolean isIntegralType(Class<?> c) {
        return c == Integer.TYPE || c == Integer.class || c == Long.TYPE || c == Long.class || c == Byte.TYPE || c == Byte.class || c == Character.TYPE || c == Character.class || c == Short.TYPE || c == Short.class;
    }

    public static boolean boxesTo(Class<?> prim, Class<?> ref) {
        return prim == Integer.TYPE && ref == Integer.class || prim == Long.TYPE && ref == Long.class || prim == Byte.TYPE && ref == Byte.class || prim == Character.TYPE && ref == Character.class || prim == Short.TYPE && ref == Short.class || prim == Boolean.TYPE && ref == Boolean.class || prim == Float.TYPE && ref == Float.class || prim == Double.TYPE && ref == Double.class;
    }

    static {
        TigerUtilities.resetVersion();
    }
}

