package Interfaces;

//note the keyword "interface" is used instead of class.
public interface Transport {
	
	
	/* Interfaces are treated like "contracts" between developers.
	 * It allows others to build components that work with our
	 * systems as long as the objects they create meet all
	 * the requirements listed in the interface.
	 * 
	 * We don't necessarily care specifically how the object
	 * they build does what it does.  We only care that it
	 * is capable of performing whatever capabilities we 
	 * wrote into the "contract"(Interface).
	 */
	
	//below are examples of how to add capabilities to an interface.
	//notice that we don't have parenthesis or curl brackets.
	//We are not defining the methods, we are just declaring them.
	public void turn(Angle degree);
	public void accelerate(Velocity v1);
	public void decelerate(Velocity v1);
	public Vector getVector();

}