import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * The recorder keeps track of how many letters have been pressed and can tell 
 * if all have been pressed.
 * 
 * @author Adrienne Decker 
 * @version Fall 2010 - Lab 5
 */
public class Recorder  extends Actor
{
    private java.util.Set<String> _pressedLetters;
    private boolean _allPressed;
    
    /**
     * Creates an instance of the Recorder with an empty collection of letters
     * already pressed.
     */
    public Recorder() {
        _pressedLetters = new java.util.HashSet<String>();
        _allPressed = false;
    }
    
    /**
     * Act - do whatever the Recorder wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        //The recorder doesn't do anything when act is called.
    }    
    
    /**
     * Call this method whenever a key is pressed by the user so that the recorder
     * records that the key has been pressed.
     */
    public void keyPressed(String key) {
        _pressedLetters.add(key);
        checkIfAllLettersPressed();
    }
    
    /**
     * This method returns true when all the letters have been pressed, false otherwise.
     */
    public boolean allPressed() {
        //return _allPressed;
        return true;
    }
    
    private void checkIfAllLettersPressed() {
        if(_pressedLetters.size() == 26) {
            _allPressed = true;
        }
    }
}
