import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Bomb here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Bomb  extends Actor
{
    private GreenfootImage[] _images;
    private static final int NUMBER_IMAGES = 30;
    private int _imageCount;
    
    public Bomb() {
        initializeImages();
        setImage(_images[0]);
        _imageCount = 0;
    }
    
    private void initializeImages() {
        if(_images == null) {
            GreenfootImage baseImage = new GreenfootImage("bomb.png");
            _images = new GreenfootImage[NUMBER_IMAGES];
            
            for(int i = 0; i < NUMBER_IMAGES; i++) {
                _images[i] = new GreenfootImage(baseImage);
               
                int size = (i+1) * (baseImage.getWidth()/NUMBER_IMAGES);
                _images[i].scale(size,size);
            }
        }
    }
    
    /**
     * Act - do whatever the Bomb wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        grow();
    }    
    
    private void grow() {
        if(_imageCount < 30) {
          setImage(_images[_imageCount]);
          _imageCount++;
        }
        else {
            getWorld().removeObject(this);
            getWorld().addObject(new Explosion(), getX(), getY());
        }
    }
}
