package containers;

import graphics.DrawingCanvas;
import graphics.colors.Black;
import graphics.colors.White;

import java.awt.Component;

/**
 * A simpler version of an Applet.  Based on CSE115.Containers.Applet written by Phil Ventura.
 * <br/>
 * The background color is Black, the Canvas color is White
 *
 * @author <a href="mailto: adrienne@cse.buffalo.edu">Adrienne Decker</a>
 * 
 */
public class Applet extends javax.swing.JApplet{

	/** The DrawingCanvas on this Applet **/
	public static DrawingCanvas CANVAS;
	private Column _col;
	
	/**
	 * Creates a new instance of Applet
	 */
	public Applet(){
		_col = new Column();
		this.add(_col);
		_col.setColor(new Black());
		
		CANVAS = new DrawingCanvas();
		CANVAS.setColor(new White());
		_col.add(CANVAS);
	}
	
	/**
	 * Allow users to add any graphical component to the column of this Applet.
	 * @param c The component to be added.
	 */
	public void addToColumn(Component c){
		_col.add(c);
	}
	
}// Applet
