package containers;

import graphics.DrawingCanvas;

/**
 * A frame with a static DrawingCanvas so that other classes can draw without
 * needing parameters. This class is based on a Frame class written by Matt
 * Chotin and then subsequently modified by Carl Alphonce.
 * 
 * @author <a href="mailto:mhc@cs.brown.edu">Adrienne Decker</a>
 * 
 */

public class Frame extends javax.swing.JFrame {
	/** Other CSE115 classes should use this for creating themselves. */
	public static graphics.DrawingCanvas CANVAS;

	/**
	 * Create the Frame, set the size, and create the DrawingCanvas for
	 * everything else to use.
	 */
	public Frame() {
		this.setPreferredSize(new java.awt.Dimension(750, 650));
		containers.Column col = new containers.Column();
		this.add(col);
		CANVAS = new DrawingCanvas();
		CANVAS.setDimension(new java.awt.Dimension(750, 600));
		col.add(CANVAS);
		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		// this.show();
		this.setVisible(true);
	}
}
