package containers;

/**
 * An applet with a three static DrawingCanvases so that other classes can draw
 * without needing parameters.  Made for Lab 4 of Fall 2006 semester.  Based on
 * TwoDrawingPanelApplet created originally by Carl Alphonce.
 *
 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
 * 
 * 
 */
public class Lab3Applet extends javax.swing.JApplet {

  /** Other CSE115 classes should use these for creating themselves. */
  public static graphics.DrawingCanvas LEFTPANEL;
  public static graphics.DrawingCanvas CENTERPANEL;
  public static graphics.DrawingCanvas RIGHTPANEL;
  public static containers.Row BASE;
  
  private static int _whichCanvas = 0;

  /**
   * Create the Applet, set the size, and create the drawingpanels for
   * everything else to use.
   */
  public Lab3Applet() {
    super();
    this.setPreferredSize(new java.awt.Dimension(750, 600));
    BASE = new containers.Row();
    this.add(BASE);
    LEFTPANEL = new graphics.DrawingCanvas();
    LEFTPANEL.setDimension(new java.awt.Dimension(250, 300));
    BASE.add(LEFTPANEL);
    CENTERPANEL = new graphics.DrawingCanvas();
    CENTERPANEL.setDimension(new java.awt.Dimension(250, 300));
    BASE.add(CENTERPANEL);
    RIGHTPANEL = new graphics.DrawingCanvas();
    RIGHTPANEL.setDimension(new java.awt.Dimension(250, 300));
    BASE.add(RIGHTPANEL);

    setColors();
  }

   private void setColors() {
      BASE.setColor(java.awt.Color.GRAY);
      LEFTPANEL.setColor(java.awt.Color.WHITE);
      CENTERPANEL.setColor(new java.awt.Color(240,240,240));
      RIGHTPANEL.setColor(java.awt.Color.WHITE);
   }
   
   /**
    * Clears the left canvas.
 	*/
   public static void clearLeft() {
	   java.util.Collection<graphics.IGraphic> graphics = new java.util.ArrayList<graphics.IGraphic>(LEFTPANEL.getAllGraphics());
	   for(graphics.IGraphic g: graphics) {
		   LEFTPANEL.remove(g);
	   }
   }
   
   /**
    * Clears the center canvas.
    */
   public static void clearCenter() {
	   java.util.Collection<graphics.IGraphic> graphics = new java.util.ArrayList<graphics.IGraphic>(CENTERPANEL.getAllGraphics());
	   for(graphics.IGraphic g: graphics) {
		   CENTERPANEL.remove(g);
	   }
   }
   
   /**
    * Clears the right canvas. 
    */
   public static void clearRight() {
	   java.util.Collection<graphics.IGraphic> graphics = new java.util.ArrayList<graphics.IGraphic>(RIGHTPANEL.getAllGraphics());
	   for(graphics.IGraphic g: graphics) {
		   RIGHTPANEL.remove(g);
	   }
   }
   
   /**
    * Clears all the canvases.
    */
   public static void clearAll() {
	   clearLeft();
	   clearCenter();
	   clearRight();
   }
   
   	/**
   	 * Ensures that only one element is on each panel, returns the panels in order left to right.
   	 * @return the canvas to create the next element on.
   	 */
	public static graphics.DrawingCanvas nextPanel() {
	   switch(_whichCanvas) {
	   case 0:
		   _whichCanvas++;
		   return LEFTPANEL;
	   case 1:
		   _whichCanvas++;
		   return CENTERPANEL;
	   case 2:
		   _whichCanvas++;
		   return RIGHTPANEL;
	   default:
		   return null;
	   }
   }

}

