package containers;

import graphics.DrawingCanvas;
import graphics.colors.Black;
import graphics.colors.White;

/**
 * An applet with a static Panel so that other classes can draw without
 * needing parameters and a column for buttons.
 * 
 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
 * 
 * 
 */

public class Lab4Applet extends javax.swing.JApplet{
	
	/** The DrawingCanvas on this Applet **/
	public static graphics.DrawingCanvas CANVAS;
	
	/** The Row on this Applet **/
	public static containers.Row ROW;
	
	/** The column on this Applet to put buttons on **/
	public static containers.Column BUTTON_COLUMN;
	
	/**
	 * Creates a new instance of Applet
	 */
	public Lab4Applet() {
		ROW = new containers.Row();
		this.add(ROW);
		ROW.setColor(new Black());
		
		CANVAS = new DrawingCanvas();
		CANVAS.setColor(new White());
		CANVAS.setDimension(new java.awt.Dimension(500,500));
		ROW.add(CANVAS);
		
		BUTTON_COLUMN = new containers.Column();
		BUTTON_COLUMN.setColor(new graphics.colors.Grey());
		ROW.add(BUTTON_COLUMN);
	}
	
	/**
	 * Returns the column that is on the Applet so that buttons or other elements can be placed upon it.
	 * @return the column to place buttons on.
	 */
	public static containers.Column getButtonColumn() {
		return BUTTON_COLUMN;
	}
	

	

}
