package containers;

/**
 * 
 * A slight modification of the JPanel adding Color and Dimension accessor/mutators
 *
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael Kozelsky</a>
 *
 * Created on: Aug 26, 2006
 *
 *
 * Panel.java
 */
public class Panel extends javax.swing.JPanel {

	/**
	 * Creates a new instance of Rest
	 */
	public Panel() {
	}

	/**
	 * Creates a new instance of Rest
	 * @param layout
	 */
	public Panel(java.awt.LayoutManager layout) {
		super(layout);
	}

	/**
	 * Creates a new instance of Rest
	 * @param isDoubleBuffered
	 */
	public Panel(boolean isDoubleBuffered) {
		super(isDoubleBuffered);
	}

	/**
	 * Creates a new instance of Panel
	 * @param layout
	 * @param isDoubleBuffered
	 */
	public Panel(java.awt.LayoutManager layout, boolean isDoubleBuffered) {
		super(layout, isDoubleBuffered);
	}
	
	/**
	 * sets the color of this panel
	 * @param c the color to set this panel to
	 */
	public void setColor(java.awt.Color c){
		this.setBackground(c);
	}

	/**
	 * returns the color of this panel
	 * @return a java.awt.Color that is the color of this panel
	 */	
	public java.awt.Color getColor() {
		return this.getBackground();
	}
	
	/**
	 * Strictly sets the dimension of this panel to be the given dimension
	 * @param d the dimension to set the panel to be
	 */
	public void setDimension(java.awt.Dimension d){
		this.setPreferredSize(d);
		this.setSize(d);
	}

	/**
	 * gets the dimension of this panel
	 * @return a java.awt.Dimension that is the dimension of this panel
	 */
	public java.awt.Dimension getDimension() {
		return this.getSize();
	}
}
