package containers;

/**
 * An applet with a two static Panels so that other classes can draw
 * without needing parameters.
 *
 * @author <a href="mailto:alphonce@cse.buffalo.edu">Carl Alphonce</a>
 * 
 * Modifications by <a href="mailto:alphonce@cse.buffalo.edu">Carl Alphonce</a>
 * in 08/2005:
 * 
 *   - Moved from CSE115 package to CSE115.Containers package.
 *   
 * Modifications by <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
 * in 9/2006:
 * 	  
 * 	 - Updated for new graphics package
 * 
 */

public class TwoDrawingCanvasApplet extends javax.swing.JApplet {

  /** Other CSE115 classes should use these for creating themselves. */
  public static graphics.DrawingCanvas LEFTPANEL;
  public static graphics.DrawingCanvas RIGHTPANEL;
  public static containers.Row BASE;
  public static containers.Column BUTTONCOLUMN;

  /**
   * Create the Applet, set the size, and create the drawingpanel for
   * everything else to use.
   */
  public TwoDrawingCanvasApplet() {
    super();
    this.setPreferredSize(new java.awt.Dimension(750, 600));
    BASE = new containers.Row();
    this.add(BASE);
    LEFTPANEL = new graphics.DrawingCanvas();
    LEFTPANEL.setDimension(new java.awt.Dimension(200, 200));
    BASE.add(LEFTPANEL);
    BUTTONCOLUMN = new containers.Column();
    BASE.add(BUTTONCOLUMN);
    RIGHTPANEL = new graphics.DrawingCanvas();
    RIGHTPANEL.setDimension(new java.awt.Dimension(200, 200));
    BASE.add(RIGHTPANEL);

    setColors();
  }

   private void setColors() {
      BASE.setColor(java.awt.Color.GRAY);
      LEFTPANEL.setColor(java.awt.Color.WHITE);
      RIGHTPANEL.setColor(java.awt.Color.WHITE);
      BUTTONCOLUMN.setColor(java.awt.Color.GRAY);
   }

}

