package demos.bounce;

import utilities.Timer;
import containers.Applet;
import graphics.movement.BouncingMovement;

public class BouncingTriangle extends graphics.Polygon {

	/**
	 * Direction vector of the square.
	 */
	private utilities.Vector _directionVector;

	/**
	 * Timer that controls the animation of the square.
	 * 
	 */
	private utilities.Timer _timer;

	/**
	 * Creates a new instance of BouncingSquare
	 */
	public BouncingTriangle() {
		this.addPoint(new java.awt.Point(0, 0));
		this.addPoint(new java.awt.Point(2, 0));
		this.addPoint(new java.awt.Point(1, 2));

		//Set dimension of the BouncyShape
		this.setDimension(new java.awt.Dimension(20, 20));

		//Set dimension of canvas the BouncyShape is on
		Applet.CANVAS.setDimension(new java.awt.Dimension(320, 200));

		//Set color of the BouncyShape
		this.setColor(java.awt.Color.red);
		
		//Set the location of the BouncyShape
		this.setLocation(Applet.CANVAS.randomPoint());
		
		//Set the speed of the BouncyShape
		_directionVector = new utilities.Vector(6,6);
		
		//Make the BouncyShape bounce
		this.setMovement(new BouncingMovement());
		
		//Add BouncyShape to canvas
		Applet.CANVAS.add(this);
		
		_timer = new Timer(1){
			@Override
			public void activate() {
				_directionVector = move(_directionVector);
			}
		};
		_timer.start();
	}
	
	/**
	 * Method to be called when user wants the BouncyShape to stop bouncing.
	 */
	public void stopBouncing() {
		_timer.stop();
	}

	/**
	 * Method to be called when the user wants the BouncyShape to start bouncing.
	 */
	public void startBouncing() {
		_timer.start();
	}
	
	/**
	 * Sets the speed of the movement.  Note that the speed will be set to the
	 * same value in both the x and y direction.
	 * 
	 * @param newSpeed A number that represents how far in pixels the movement
	 * should be each time.
	 */
	public void setSpeed(Integer newSpeed) {
		_directionVector = new utilities.Vector(newSpeed, newSpeed);

	}
	
	/**
	 * Returns the speed of the movement.  Since the speed is always set to be
	 * the same in the x and y direction, this value applies to speed in both
	 * directions.
	 * @return A number that represents how far in pixels the movement is currently
	 * set to.
	 */
	public Integer getSpeed() {
		return _directionVector.getDx();
	}
	
	/**
	 * @see graphics.AbstractGraphic#setDimension(java.awt.Dimension)
	 * @param newDimension
	 */
	@Override
	public void setDimension(java.awt.Dimension newDimension) {
		super.setDimension(newDimension);
	}
	
	/**
	 * @see graphics.AbstractColorableGraphic#setColor(java.awt.Color)
	 * @param newColor
	 */
	public void setColor(graphics.colors.Color newColor) {
		super.setColor(newColor);
	}
}