package demos.polymorphism;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;

/**
 * ConcreteMotionMenuItem.java
 * 
 * 
 * Created: Tue Sep 17 22:32:31 2002
 * 
 * @author <a href="mailto:pventura@cse.buffalo.edu">Phil Ventura</a>
 */

class ConcreteMotionMenuItem extends JMenuItem implements
		MotionMenuItem {

	/**
	 * The behavior to invoke when the menu item is selected.
	 * 
	 */
	private MenuBehavior _behavior;

	/**
	 * Creates a new <code>ConcreteMotionMenuItem</code> instance.
	 * 
	 * @param menu
	 *            the menu to place it on.
	 * @param menuText
	 *            the text of the menu item.
	 */
	ConcreteMotionMenuItem(String menuText) {
		super(menuText);
		_behavior = NullBehavior.getSingleton();
		
		this.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				ConcreteMotionMenuItem.this.itemSelected();
			}
		});
	}

	// implementation of demos.polymorphism.RotationMenuItem interface
	/**
	 * Set the behavior of the menu item.
	 * 
	 * @param behavior
	 *            a <code>MenuBehavior</code> value
	 */
	public void setMenuBehavior(MenuBehavior behavior) {
		_behavior = behavior;
	}

	/**
	 * Called when the menuItem is selected on the menu.
	 * 
	 */
	public void itemSelected() {
		// delegate to behavior object
		_behavior.menuItemSelected(this);
	}
} // ConcreteMotionMenuItem
