package demos.polymorphism;

/**
 * NullBehavior.java
 *
 *
 * Created: Tue Sep 17 22:35:50 2002
 *
 * @author <a href="mailto:pventura@cse.buffalo.edu">Phil Ventura</a>
 */

class NullBehavior implements MenuBehavior {
  private static final NullBehavior SINGLETON = new NullBehavior();

  private NullBehavior (){ }

  /**
   * Get the singleton (only instance of the NullBehavior class).
   *
   * @return the singleton (only instance of the NullBehavior class).
   */
  static NullBehavior getSingleton() { return SINGLETON; }

  // implementation of demos.polymorphism.MenuBehavior interface
  /**
   * Do nothing -- that's the point of the NullObject design pattern.
   *
   * @param item a <code>MotionMenuItem</code> value
   */
  public void menuItemSelected(MotionMenuItem item) { }
} // NullBehavior
