package fishbowl;

import java.util.Observer;

import utilities.Timer;

/**
 * <b>Normal users can ignore this class.</b> Tells MovingBody objects when to
 * move.
 * 
 * 
 * Created: Sun Feb 10 14:53:56 2002
 * 
 * @author <a href="mailto: pventura@westga.edu">Phil Ventura</a>
 */
public class Animator {

	/** The object that tells all the balls to move. **/
	private Dispatcher _dispatcher;

	/** The timer that controls the animation. **/
	private Timer _timer;

	/** The only instance of BallAnimator. **/
	private static final Animator SINGLETON = new Animator(500);

	/**
	 * Get the Animator.
	 * 
	 * @return the (singleton) Animator instance.
	 */
	public static Animator singleton() {
		return SINGLETON;
	}

	/**
	 * Creates a new <code>Animator</code> instance.
	 * 
	 * @param refresh
	 *            how often (in milliseconds) to move the observers (i.e. Balls
	 *            or Fish).
	 */
	private Animator(int refresh) {
		_dispatcher = new Dispatcher();
		_timer = new Timer(refresh) {
			@Override
			public void activate() {
				Animator.this.activate();
			}
		};
		_timer.start();
	}

	/**
	 * Add a body to the animator.
	 * 
	 * @param b
	 *            the moving body to add.
	 */
	public void addBody(Observer b) {
		_dispatcher.addObserver(b);
	}

	/**
	 * Remove a body from the animator.
	 * 
	 * @param b
	 *            the moving body to remove.
	 */
	public void deleteBody(Observer b) {
		_dispatcher.deleteObserver(b);
	}

	/**
	 * Remove all the bodies from the animator.
	 * 
	 */
	public void deleteBodies() {
		_dispatcher.deleteObservers();
		containers.Applet.CANVAS.removeAllGraphics();
	}

	/**
	 * Tells the dispatcher to update all the observers
	 */
	private void activate() {
		_dispatcher.update();
	}

	/**
	 * Set the delay between moving the balls.
	 * 
	 * @param delay
	 *            the new delay.
	 */
	public void setDelay(int delay) {
		_timer.setDelay(delay);
	}

	/**
	 * Start animation.
	 */
	public void start() {
		_timer.start();
	}

	/**
	 * Stop animating.
	 */
	public void stop() {
		_timer.stop();
	}

}// Animator
