package fishbowl;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButtonMenuItem;

/**
 * An applet for strategy fish.
 *
 *
 * Created: Sat Mar 09 13:12:06 2002
 *
 * @author <a href="mailto:pventura@cse.buffalo.edu">Phil Ventura</a>,
 *modified by <a href="mailto:adrienne@cse.bufflao.edu">Adrienne Decker</a>
 */

public class Applet extends containers.Applet {
  /**
   * The menus.
   *
   */
    private javax.swing.JMenu _singleFishMenu, _multiFishMenu;

  /**
   * The menu bar.
   *
   */
  private javax.swing.JMenuBar _menuBar;

  /**
   * Creates a new <code>Applet</code> instance.
   *
   */
  public Applet (){
    CANVAS.setColor(java.awt.Color.CYAN);
    CANVAS.setDimension(new java.awt.Dimension(620,400));
    _menuBar = new javax.swing.JMenuBar();
    this.setJMenuBar(_menuBar);
    _singleFishMenu = new javax.swing.JMenu("Single Behavior Fish");
    _menuBar.add(_singleFishMenu);
    _multiFishMenu = new javax.swing.JMenu("Multi Behavior Fish");
    _menuBar.add(_multiFishMenu);
  }

  /**
   * Create the menus.
   *
   * @param singleFishObserver the object to notify for the <i>Single
   * Fish</i> menu clicks.
   * @param multiFishObserver the object to notify for the <i>Multi
   * Fish</i> menu clicks.  
   * @see SingleFishBehaviorMenuObserver
   * @see MultiFishBehaviorMenuObserver

   */
  public void createMenu(final SingleFishBehaviorMenuObserver 
			 singleFishObserver, 
			 final MultiFishBehaviorMenuObserver 
			 multiFishObserver) {
    
    this.createSingleFishMenu(singleFishObserver);
    this.createMultiFishMenu(multiFishObserver);
  }

  /**
   * Get the menubar. <i>Note: You only need this if you are adding
   * new menus.</i>
   *
   * @return the menubar.
   */
  public javax.swing.JMenuBar getMenuBar() {
    return _menuBar;
  }

  /**
   * Get the <i>Single Fish</i> menu. <i>Note: You only need this if you
   * are adding new menu items to the single fish menu.</i>
   *
   * @return the <i>Single Fish</i> menu.
   */
  public javax.swing.JMenu getSingleFishMenu() {
    return _singleFishMenu;
  }

  /**
   * Get the <i>Multi Fish </i> menu. <i>Note: You only need this if you are
   * adding new menu items to the multi fish menu.</i>
   *
   * @return the <i>Multi Fish</i> menu.
   */
  public javax.swing.JMenu getMultiFishMenu() {
    return _multiFishMenu;
  }

  /**
   * Create the menu for the single behavior fish.
   *
   * @param singleFishObserver the object to be notified when a menu
   * option is selected.
   */
  private void createSingleFishMenu(final SingleFishBehaviorMenuObserver singleFishObserver) {
    if ( singleFishObserver == null ) {
      System.err.println("No SingleFishBehaviorMenuObserver installed.");
      return;
    } // end of if ()

    javax.swing.JMenuItem item = new javax.swing.JMenuItem("Make it");
    item.addActionListener(new java.awt.event.ActionListener() {
    	public void actionPerformed(java.awt.event.ActionEvent e) {
    		singleFishObserver.createSingleBehaviorFish();
    	}
    });
    _singleFishMenu.add(item);

    _singleFishMenu.addSeparator();

    ButtonGroup bg = new ButtonGroup();
    JRadioButtonMenuItem b;

    b = new JRadioButtonMenuItem(new AbstractAction("Regular") {
	public void actionPerformed(ActionEvent evt) {
	  singleFishObserver.regularSelected();
	}
      });
    _singleFishMenu.add(b);
    b.doClick();
    bg.add(b);

    b = new JRadioButtonMenuItem(new AbstractAction("Chameleon") {
	public void actionPerformed(ActionEvent evt) {
	  singleFishObserver.chameleonSelected();
	}
      });
    _singleFishMenu.add(b);
    bg.add(b);

    b = new JRadioButtonMenuItem(new AbstractAction("Dizzy") {
	public void actionPerformed(ActionEvent evt) {
	  singleFishObserver.dizzySelected();
	}
      });
    _singleFishMenu.add(b);
    bg.add(b);
    
    b = new JRadioButtonMenuItem(new AbstractAction("Random Swim") {
    public void actionPerformed(ActionEvent evt) {
    	singleFishObserver.randomSwimSelected();
    }
      });
    _singleFishMenu.add(b);
    bg.add(b);
    
    b = new JRadioButtonMenuItem(new AbstractAction("Surprise (Extra Credit)") {
        public void actionPerformed(ActionEvent evt) {
        	singleFishObserver.surpriseSelected();
        }
          });
        _singleFishMenu.add(b);
        bg.add(b);
  }

   /**
   * Create the menu for the multi fish.
   *
   * @param multiFishObserver the object to notify when a menu option is
   * selected.
   */
  private void createMultiFishMenu(final MultiFishBehaviorMenuObserver multiFishObserver) {
    if ( multiFishObserver == null ) {
      System.err.println("No MultiFishBehaviorMenuObserver installed.");
      return;
    } // end of if ()
    
    javax.swing.JMenuItem item = new javax.swing.JMenuItem("Make it");
    item.addActionListener(new java.awt.event.ActionListener() {
    	public void actionPerformed(java.awt.event.ActionEvent e) {
    		multiFishObserver.createMultiBehaviorFish();
    	}
    });

    _multiFishMenu.add(item);
    _multiFishMenu.addSeparator();

    JCheckBoxMenuItem b;
    b = new JCheckBoxMenuItem(new AbstractAction("Chameleon") {
	public void actionPerformed(ActionEvent evt) {
	  JCheckBoxMenuItem cb = (JCheckBoxMenuItem) evt.getSource();
	  if ( cb.isSelected() ) {
	    multiFishObserver.chameleonSelected();
	  }
	  else {
	    multiFishObserver.chameleonDeselected();
	  } // end of else
	}
      });
    _multiFishMenu.add(b);

    b = new JCheckBoxMenuItem(new AbstractAction("Dizzy") {
	public void actionPerformed(ActionEvent evt) {
	  JCheckBoxMenuItem cb = (JCheckBoxMenuItem) evt.getSource();
	  if ( cb.isSelected() ) {
	    multiFishObserver.dizzySelected();
	  } // end of if ()
	  else {
	    multiFishObserver.dizzyDeselected();
	  }
	}
      });
    _multiFishMenu.add(b);

    b = new JCheckBoxMenuItem(new AbstractAction("Random Swim") {
    	public void actionPerformed(ActionEvent evt) {
    	  JCheckBoxMenuItem cb = (JCheckBoxMenuItem) evt.getSource();
    	  if ( cb.isSelected() ) {
    	    multiFishObserver.randomSwimSelected();
    	  } // end of if ()
    	  else {
    	    multiFishObserver.randomSwimDeselected();
    	  }
    	}
          });
        _multiFishMenu.add(b);
  }
 
}// Applet
