package fishbowl;

import graphics.Polygon;
import graphics.movement.BouncingMovement;

import java.util.Observable;

import utilities.Vector;
import containers.Applet;

/**
 * A Fish that moves when told to.
 *
 * Created: Thu Sep 29 15:00:55 2005
 *
 * @author <a href="mailto: alphonce@cse.buffalo.edu"> Carl Alphonce</a>
 * @version 1.3
 */

public class Fish extends Polygon implements java.util.Observer{
	
	private utilities.Vector _vector;
	
    /**
     * Creates a new <code>Fish</code> instance.
     *
     */
    public Fish() {

		this.addPoint(new java.awt.Point(0, 1));
		this.addPoint(new java.awt.Point(1, 0));
		this.addPoint(new java.awt.Point(2, 1));
		this.addPoint(new java.awt.Point(1, 2));
		this.addPoint(new java.awt.Point(2, 3));
		this.addPoint(new java.awt.Point(0, 3));
		this.addPoint(new java.awt.Point(1, 2));
		
//    	System.out.println("fish: " + this.getDimension());
    	
    	//Set dimension of the fish
		this.setDimension(new java.awt.Dimension(20, 20));

		//Set the location of the fish
		this.setLocation(containers.Applet.CANVAS.randomPoint());
		
		//Set color of the fish
		this.setColor(java.awt.Color.red);
				
		//Set the speed of the fish
		_vector = new utilities.Vector(6,6);
		
		//Set the rotation
		this.setRotation( _vector.getDx() > 0 ? 90 : 270);
		
		//Set the movement
		this.setMovement(new BouncingMovement());
		
		//Add fish to canvas
		Applet.CANVAS.add(this);		
		
		//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		//this is probably not the best way to do it
		Animator.singleton().addBody(this);
		Animator.singleton().start();

    }

    /**
     * Returns the size of the Fish.
     * @return the size of the Fish.
     */
    public Integer getSize() {
    	return this.getDimension().width;
    }

    /**
     * Sets the size of the Fish.
     * @param size the new size of the Fish
     */
    public void setSize(Integer size) {
    	this.setDimension(new java.awt.Dimension(size, size));
    }

    /**
     * Update the position and orientation of the fish based on the
     * velocity.  If the fish hits a wall, it reverses velocity in the
     * appropriate direction and points in the appropriate direction
     * too.
     */
	public void update() {
		_vector = this.move(_vector);
	}
	
	public Vector getVector() {
		return _vector;
	}
	
	public void setVector(Vector v) {
		_vector = v;
	}
	
	public Integer getDx(){
		return _vector.getDx();
	}
	
	public Integer getDy(){
		return _vector.getDy();
	}
	
	public void update(Observable o, Object arg) {
		this.update();
	}

  
}// Fish
