package fishbowl;

/**
 * Methods called <i>auto-magically</i> when the user clicks an
 * option from the <i>Multi Fish</i> behavior menu of Applet.
 *
 *
 * Created: Sat Mar 09 14:11:12 2002
 *
 * @author <a href="mailto:pventura@cse.buffalo.edu">Phil Ventura</a>,
 *modified by <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
 */

public interface MultiFishBehaviorMenuObserver {
  /**
   * The create multi fish behavior menu option was selected.
   *
   */
  public abstract void createMultiBehaviorFish();

  /**
   * The chameleon fish radio button was selected.
   *
   */
  public abstract void chameleonSelected();

  /**
   * The chameleon fish radio button was deselected.
   *
   */
  public abstract void chameleonDeselected();

  /**
   * The dizzy fish radio button was selected.
   *
   */
  public abstract void dizzySelected();
  
  /**
   * The dizzy fish radio button was deselected.
   *
   */
  public abstract void dizzyDeselected();
  
  /**
   * The random swim fish radio button was selected.
   *
   */
  public abstract void randomSwimSelected();
  
  /**
   * The random swim fish radio button was deselected.
   *
   */
  public abstract void randomSwimDeselected();  
  
}// MultiFishBehaviorMenuObserver
