package fishbowl;

/**
 * Methods called <i>auto-magically</i> when the user clicks an
 * option from the <i>Single Fish</i> behavior menu of Applet.
 *
 *
 * Created: Sat Mar 09 13:03:07 2002
 *
 * @author <a href="mailto:pventura@cse.buffalo.edu">Phil Ventura</a>, modified by <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
 */

public interface SingleFishBehaviorMenuObserver {
  /**
   * The create single behavior fish menu option was selected.
   *
   */
  public abstract void createSingleBehaviorFish();

  /**
   * The regular fish radio button was selected.
   *
   */
  public abstract void regularSelected();

  /**
   * The chameleon fish radio button was selected.
   *
   */
  public abstract void chameleonSelected();

  /**
   * The dizzy fish radio button was selected.
   *
   */
  public abstract void dizzySelected();

  /**
   * The random swim fish radio button was selected.
   *
   */
  public abstract void randomSwimSelected();
  
  
  /**
   * The surprise fish radio button was selected.
   */
  public abstract void surpriseSelected();
  
}// SingleFishBehaviorMenuObserver
