package graphics;

import java.awt.geom.Area;

/**
 * 
 * A Graphic that is in the outline Ellipse. If the height and width are set
 * to be the same thing, lo and behold, a circle emerges.
 * 
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael Kozelsky</a>
 * 
 * Created on: Jul 28, 2006
 * 
 * 
 * Ellipse.java
 */
public class FramedEllipse extends AbstractColorableGraphic {

	/**
	 * Creates a new instance of Ellipse with a Dimension of 0,0 and Location of
	 * 0,0
	 */
	public FramedEllipse() {
	}

	/**
	 * This method uses the Graphics2D object to paint an ellipse onto the
	 * container at a specified point with a specified dimension
	 * 
	 * @see graphics.IGraphic#actualPaint(java.awt.Graphics2D,
	 *      java.awt.Point, java.awt.Dimension)
	 * @param gs
	 *            The Graphics2D object to do the painting
	 * @param location
	 *            The point at which to paint the Ellipse
	 * @param dimension
	 *            The dimension of the Ellipse to paint
	 */
	public void actualPaint(java.awt.Graphics2D gs, java.awt.Point location,
			java.awt.Dimension dimension) {
		gs.drawOval(location.x, location.y, dimension.width-1, dimension.height-1);
	}

	/**
	 * @see graphics.IGraphic#getShape()
	 * @return a java.awt.geom.Ellipse2D.Double
	 */
	public java.awt.Shape getShape() {
		Area frame = new Area(new java.awt.geom.Ellipse2D.Double(this.getLocation().x, this
				.getLocation().y, this.getDimension().getWidth(), this
				.getDimension().getHeight()));
		Area inside = new Area(new java.awt.geom.Ellipse2D.Double(this.getLocation().x+1, this
				.getLocation().y+1, this.getDimension().getWidth()-2, this
				.getDimension().getHeight()-2));
		frame.subtract(inside);
		
		return this.applyRotation(frame);
	}
}
