package graphics;

import java.awt.geom.Area;

/**
 * A Graphic that is the outline of a rectangle.
 * 
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael Kozelsky</a>
 * 
 * Created on: Jul 29, 2006 Rectangle.java
 */
public class FramedRectangle extends AbstractColorableGraphic {

	/**
	 * Creates a new instance of the Rectangle Graphic with dimension (0,0) and
	 * location(0,0)
	 */
	// TODO: all graphics should be noted what their start values are
	public FramedRectangle() {
	}

	/**
	 * This method uses the Graphics2D object to paint a FramedRectangle onto
	 * the container at a specified point with a specified dimension
	 * 
	 * @see graphics.IGraphic#actualPaint(java.awt.Graphics2D,
	 *      java.awt.Point, java.awt.Dimension)
	 * @param gs
	 *            The Graphics2D object to do the painting
	 * @param location
	 *            The point at which to paint the rectangle
	 * @param dimension
	 *            The dimension of the rectangle to paint
	 */
	public void actualPaint(java.awt.Graphics2D gs, java.awt.Point location,
			java.awt.Dimension dimension) {
		gs.drawRect(location.x, location.y, dimension.width-1, dimension.height-1);
	}

	/**
	 * @see graphics.IGraphic#getShape()
	 * @return a java.awt.Rectangle
	 */
	public java.awt.Shape getShape() {
		java.awt.geom.Area rectangleFrame = new Area(new java.awt.Rectangle(this.getLocation().x,
				this.getLocation().y, this.getDimension().width, this.getDimension().height));
		
		java.awt.geom.Area rectangleBody  = new Area(new java.awt.Rectangle(this.getLocation().x+1,
				this.getLocation().y+1, this.getDimension().width-2, this.getDimension().height-2));
		
		//subtract the body of the rectangle from the frame
		rectangleFrame.subtract(rectangleBody);
		
		return this.applyRotation(rectangleFrame);
	}


}
