package graphics;

import java.awt.Rectangle;

/**
 * 
 * The interface that defines the capabilties for an object that can contain Graphics
 * 
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael Kozelsky</a>
 * 
 * Created on: Jul 29, 2006 IContainer.java
 */
public interface IContainer extends java.awt.image.ImageObserver {

	/**
	 * Adds a Graphic onto this Container
	 * 
	 * @param g
	 *            The Graphic to put on/in this Container
	 */
	public void add(IGraphic g);

	/**
	 * Removes a Graphic from this Container
	 * 
	 * @param g
	 *            The Graphic to remove from this Container
	 */
	public void remove(IGraphic g);

	/**
	 * Returns the Dimension of this Container
	 * 
	 * @return the Dimension
	 */
	public java.awt.Dimension getDimension();
	
	/**
	 * Forces a repaint of all the Graphics on this Container
	 */
	public void repaint();

	/**
	 * Forces a repaint of all the things that are on this Container in the given bounds
	 * @param bounds
	 */
	public void repaint(Rectangle bounds);
}
