package graphics;

/**
 * 
 * The interface that defines the capabilites for an object that is a Graphic
 * 
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael Kozelsky</a>
 * 
 * Created on: Jul 27, 2006
 * 
 * 
 * Graphic.java
 */
public interface IGraphic extends ISizeable, CenterLocatable, IRotatable {

	/**
	 * This sets the container of this graphic
	 * 
	 * @param container
	 *            the container which will contain this graphic
	 */
	public void setContainer(IContainer container);

	/**
	 * Returns the bounding box of this graphic
	 * 
	 * @return a java.awt.Rectangle representing the bounds
	 */
	public java.awt.Rectangle getBounds();

	/**
	 * Checks whether a given point is contained within this graphic
	 * 
	 * @param p
	 *            The point to check
	 * @return true if this graphic contains <code>p</code> false if not
	 */
	public boolean contains(java.awt.Point p);
	
	/**
	 * Should return a java.awt.Shape representation of this graphic.
	 * The shape is used as a delegate for the methods: contains, intersects, etc.
	 * @return a java.awt.Shape
	 */
	public java.awt.Shape getShape();

	/**
	 * This method uses the Graphics2D object to paint itself onto its container
	 * 
	 * @param gs
	 *            The Graphics2D object used to do the painting
	 */
	public void paint(java.awt.Graphics2D gs);

	/**
	 * This method uses the Graphics2D object to paint the actual shape onto the
	 * Container.
	 * 
	 * @param gs
	 *            The Graphics2D object used to do the painting
	 * @param location
	 *            The offset at which to paint this graphic
	 * @param dimension
	 *            The dimension this graphic
	 */
	public void actualPaint(java.awt.Graphics2D gs, java.awt.Point location,
			java.awt.Dimension dimension);

	/**
	 * Adds a <code>java.awt.event.MouseListener</code> onto this graphic
	 * TODO: remove mouse listener?
	 * 
	 * @param ml
	 *            The <code>java.awt.event.MouseListener</code> to listen on
	 *            this graphic
	 */
	public void addMouseListener(java.awt.event.MouseListener ml);

	/**
	 * Returns all the <code>java.awt.event.MouseListener</code>s of this
	 * graphic
	 * 
	 * @return Returns a collection containing all the
	 *         <code>java.awt.event.MouseListener</code>s of this graphic
	 */
	public java.util.Collection<java.awt.event.MouseListener> getMouseListeners();

	/**
	 * Adds a <code>java.awt.event.MouseMotionListener</code> onto this
	 * graphic TODO: remove listener?
	 * 
	 * @param mml
	 *            The <code>java.awt.event.MouseMotionListener</code> to
	 *            listen on this graphic
	 */
	public void addMouseMotionListener(java.awt.event.MouseMotionListener mml);

	/**
	 * Returns all the <code>java.awt.event.MouseMotionListener</code>s of
	 * this graphic
	 * 
	 * @return Returns a collection containing all the
	 *         <code>java.awt.event.MouseMotionListener</code>s of this
	 *         graphic
	 */
	public java.util.Collection<java.awt.event.MouseMotionListener> getMouseMotionListeners();

	/**
	 * Tests to see if two Graphics intersect with each other.
	 * @param shape the graphic to test for intersection
	 * @return true if this graphic intersects with g
	 */
	public boolean intersects(IGraphic shape);
	
	/**
	 * Get the Container this graphic is in.  May return null if this graphic has not been added to anything
	 * @return this graphics' container
	 */
	public IContainer getContainer();
	
	/**
	 * Sets the movement of the Graphic.  A movement should be a definition of
	 * how this will react to the move(utilities.Vector) method.
	 * @param movement
	 */
	public void setMovement(graphics.movement.IGraphicMovement movement);
	
	/**
	 * Returns this graphic's movement
	 * @return An IMovement
	 */
	public graphics.movement.IGraphicMovement getMovement();
}
