package graphics;

/**
 * A Graphic that is in the shape of a rectangle with slight 
 * 3-dimensionsal shading. If the height and width are set
 * to be the same thing, lo and behold, a square emerges.
 * 
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael Kozelsky</a>
 * 
 * Created on: Jul 29, 2006 Rectangle.java
 */
public class Rectangle3D extends AbstractColorableGraphic {

	/**
	 * Creates a new instance of the Rectangle3D Graphic with dimension (0,0) and
	 * location(0,0)
	 */
	// TODO: all graphics should be noted what their start values are
	public Rectangle3D() {
	}

	/**
	 * This method uses the Graphics2D object to paint a 3D rectangle onto
	 * the container at a specified point with a specified dimension
	 * 
	 * @see graphics.IGraphic#actualPaint(java.awt.Graphics2D,
	 *      java.awt.Point, java.awt.Dimension)
	 * @param gs
	 *            The Graphics2D object to do the painting
	 * @param location
	 *            The point at which to paint the rectangle
	 * @param dimension
	 *            The dimension of the rectangle to paint
	 */
	public void actualPaint(java.awt.Graphics2D gs, java.awt.Point location,
			java.awt.Dimension dimension) {
		gs.fill3DRect(location.x, location.y, dimension.width, dimension.height,true);
	}

	/**
	 * @see graphics.IGraphic#getShape()
	 * @return a java.awt.Rectangle
	 */
	public java.awt.Shape getShape() {
		java.awt.Rectangle r=  new java.awt.Rectangle(this.getLocation().x,
				this.getLocation().y, this.getDimension().width, this
						.getDimension().height);

		return this.applyRotation(r);
	}


}
