package graphics.movement;

import graphics.IGraphic;
import utilities.Vector;
import graphics.IContainer;

/**
 * TODO: fill in comments for BouncingMovement
 *
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael M Kozelsky</a>
 *
 * Created on: Nov 14, 2006
 *
 */
public class BouncingMovement implements IGraphicMovement{

	/**
	 * @see graphics.movement.IGraphicMovement#move(graphics.IGraphic, utilities.Vector)
	 * @param graphic
	 * @param v
	 */
	public Vector move(IGraphic graphic, Vector vector) {

    	IContainer container = graphic.getContainer();
    	
    	//if the container is null, do nothing and give them back the vector
    	if(container==null){
    		return vector;
    	}
		
    	//figure out the new point where the graphic should go
    	java.awt.Point p = new java.awt.Point(
    			graphic.getLocation().x + vector.getDx(), 
    			graphic.getLocation().y + vector.getDy());
    	

    	if (p.x + graphic.getDimension().width >
    		container.getDimension().width) {
    		vector.setDx(-vector.getDx());
    		graphic.setRotation(graphic.getRotation() + 180);
    		p.x = container.getDimension().width -
    		graphic.getDimension().width;
    	}
    	else if (p.x < 0) {
    		vector.setDx(-vector.getDx());
    		graphic.setRotation(graphic.getRotation() + 180);
    		p.x = 0;
    	}

    	if (p.y + graphic.getDimension().height >
    		container.getDimension().height) {
    		vector.setDy(-vector.getDy());
    		p.y = container.getDimension().height -
    		graphic.getDimension().height;
    	}
    	else if (p.y < 0) {
    		vector.setDy(-vector.getDy());
    		p.y = 0;
    	}

    	graphic.setLocation(p);
    	
    	return vector;
	}


}
