package graphics.movement;

import graphics.IGraphic;

import java.awt.Point;

import utilities.Vector;

import graphics.IContainer;

/**
 * TODO: fill in comments for WrappingMovement
 *
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael M Kozelsky</a>
 *
 * Created on: Nov 14, 2006
 *
 */
public class WrappingMovement implements IGraphicMovement {

	/**
	 * @see graphics.movement.IGraphicMovement#move(graphics.IGraphic, utilities.Vector)
	 * @param graphic
	 * @param v
	 * @return
	 */
	public Vector move(IGraphic graphic, Vector v) {
		IContainer container = graphic.getContainer();
		if(container==null){
			return v;
		}
		
		Point location = new Point(graphic.getCenterLocation().x+v.getDx(), graphic.getCenterLocation().y+v.getDy());
		
		location.x = (location.x+container.getDimension().width)%container.getDimension().width;
		location.y = (location.y+container.getDimension().height)%container.getDimension().height;
		
		graphic.setCenterLocation(location);
		
		return v;
	}

}
