package lab2lib;

import graphics.movement.BouncingMovement;
import utilities.Timer;

public class BouncingSquare extends graphics.Rectangle {

	/** Direction vector of the Square **/
	private utilities.Vector _directionVector;
	
	/** Timer that controls the animation of the Square **/
	private Timer _timer;
	
	/**
	 * Creates a new instance of BouncingSquare
	 */
	public BouncingSquare() {
		//Set dimension of the BouncyShape
		this.setDimension(new java.awt.Dimension(20, 20));

		//Set dimension of canvas the BouncyShape is on
		containers.Lab2Applet.CANVAS.setDimension(new java.awt.Dimension(320, 200));

		//Set color of the BouncyShape
		this.setColor(java.awt.Color.red);
		
		//Set the location of the BouncyShape
		this.setLocation(containers.Lab2Applet.CANVAS.randomPoint());
		
		//Set the speed of the BouncyShape
		_directionVector = new utilities.Vector(6,6);
		
		//Make the BouncyShape bounce
		this.setMovement(new BouncingMovement());
		
		//Add BouncyShape to canvas
		containers.Lab2Applet.CANVAS.add(this);
		
		_timer = new Timer(1){
			@Override
			public void activate() {
				_directionVector = move(_directionVector);
			}
		};
		_timer.start();
	}
	
	/**
	 * Method to be called when user wants the BouncyShape to stop bouncing.
	 * 
	 */
	public void stopBouncing() {
		_timer.stop();
	}

	/**
	 * Method to be called when the user wants the BouncyShape to start bouncing.
	 * 
	 */
	public void startBouncing() {
		_timer.start();
	}
}