package lab2lib;

import graphics.IColorableGraphic;

public class Lab2Program extends containers.Row {
	
	private java.util.LinkedList<graphics.IColorableGraphic> _shapes;
	
	public Lab2Program() {
		
		this.createButton();
		
		_shapes = new java.util.LinkedList<IColorableGraphic>();
		Integer numOfShapes = utilities.Random.randomInteger(3, 8);
		for(Integer i = 0; i < numOfShapes; i++) {
			Integer typeOfShape = utilities.Random.randomInteger(1, 3);
			if(typeOfShape == 1) {
				_shapes.add(new BouncingBall());
			}
			if(typeOfShape == 2){
				_shapes.add(new BouncingSquare());
			}
			else {
				_shapes.add(new BouncingTriangle());
			}
		}
	}
	
	public void createButton() {
		containers.Column col = new containers.Column();
		javax.swing.JButton colorChanger = new javax.swing.JButton("Change Color");
		col.add(colorChanger);
		containers.Lab2Applet.ROW.add(col);
		colorChanger.addActionListener(new ColorChanger(this));
	}
	
	public void changeColor(java.awt.Color color) {
		java.awt.Color selectedColor = color;
		for(IColorableGraphic g: _shapes) {
			g.setColor(selectedColor);
			selectedColor = this.darken(selectedColor);
		}
	}
	
	public java.awt.Color darken(java.awt.Color color) {
		int red = color.getRed();
		int green = color.getGreen();
		int blue = color.getBlue();
		
		red = Math.max((int)(red * 0.85), 0);
		green = Math.max((int)(green * 0.85), 0);
		blue = Math.max((int)(blue * 0.85), 0);
		
		return new java.awt.Color(red, green, blue);
	}

}
