package lab3lib;

/**
 * An interface that all Cells implement
 *
 * @author <a href="mailto:alphonce@cse.buffalo.edu">Carl G. Alphonce</a>
 *
 * Created on: Sep 22, 2006
 *
 */
public interface ICell {
	/**
	 * Creates the conditions under which a cell can grow so that we can observe its growth.
	 */
	public void grow();
	/**
	 * Stains the slide that the cell is on so that we can see it better.
	 * @param color the color you would like to stain the cell to
	 */
	public void stain(graphics.colors.Color color);
	/**
	 * Creates the conditions under which a cell would die so that we can observe its death.
	 */
	public void die();
}
