package lab3lib;


/**
 * An unidentified cell that we can observe in our Cell Observation Room.
 *
 * @author <a href="mailto:alphonce@cse.buffalo.edu">Carl G. Alphonce</a>
 *
 * Created on: Sep 22, 2006
 *
 */
public class UnidentifiedCellA implements ICell {

	private graphics.Ellipse _cell;
	private GrowthTimer _growthTimer;
	private DeathTimer _deathTimer;
	
	private graphics.DrawingCanvas _canvas;
	
	/**
	 * Creates a new instance of UnidentifiedCellA
	 * @param canvas
	 */
	public UnidentifiedCellA(graphics.DrawingCanvas canvas) {
		
		_canvas = canvas;
		
		_cell = new graphics.Ellipse();
		_cell.setDimension(new java.awt.Dimension(50,50));
		_cell.setCenterLocation(new java.awt.Point(125,150));
		_cell.setColor(utilities.Random.randomColor().brighter());
		_canvas.add(_cell);
		
		_growthTimer = new GrowthTimer(400);
		_deathTimer = new DeathTimer(900);
	}

	/**
	 * @see lab3lib.ICell#grow()
	 */
	public void grow() {
		_growthTimer.start();
	}


	/**
	 * @see lab3lib.ICell#stain(graphics.colors.Color)
	 * @param color
	 */
	public void stain(graphics.colors.Color color) {
		_cell.setColor((java.awt.Color)color);
	}

	/**
	 * @see lab3lib.ICell#die()
	 */
	public void die() {
		_deathTimer.start();
	}

	/**
	 * Timer to control animation of the growing cell
	 *
	 * @author <a href="mailto:alphonce@cse.buffalo.edu">Carl Alphonce</a>
	 *
	 * Created on: Sep 16, 2006
	 *
	 */
	private class GrowthTimer extends utilities.Timer {
		
		private java.awt.Dimension _d = _cell.getDimension();
		private int _amountToGrowBy = _d.height;
		private int _amountGrown = 0;
		
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public GrowthTimer(int delay) {
			super(delay);
		}
				
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
			if (_amountToGrowBy == 0) { 
				_amountToGrowBy = 1;
			}
			if (_amountGrown < _amountToGrowBy) {
				_cell.setDimension(new java.awt.Dimension(_d.width, _d.height + _amountGrown));
				_amountGrown++;
			}
			else {
				this.stop();
			}
			
		}
	}
	
	/**
	 * Timer to control the death of the cell
	 *
	 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
	 *
	 * Created on: Sep 24, 2006
	 *
	 */
	private class DeathTimer extends utilities.Timer {
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public DeathTimer(int delay) {
			super(delay);
		}
				
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
			java.awt.Color cellColor = _cell.getColor();
			int red = cellColor.getRed();
			int green = cellColor.getGreen();
			int blue = cellColor.getBlue();
			
			red = Math.max((int)(red * 0.99), 0);
			green = Math.max((int)(green * 0.99), 0);
			blue = Math.max((int)(blue * 0.99), 0);
			
			_cell.setColor(new java.awt.Color(red, green, blue));
			
		}
	}
}
