package lab3lib;


/**
 * An unidentified cell that we can observe in our Cell Observation Room.
 *
 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
 *
 * Created on: Sep 24, 2006
 *
 */
public class UnidentifiedCellB implements ICell {

	private graphics.Rectangle _cell;
	private StainTimer _stainTimer;
	private GrowthTimer _growthTimer;
	private DeathTimer _deathTimer;
	
	private graphics.DrawingCanvas _canvas;
	
	/**
	 * Creates a new instance of UnidentifiedCellB
	 * @param canvas
	 */
	public UnidentifiedCellB(graphics.DrawingCanvas canvas) {
		
		_canvas = canvas;
		
		_cell = new graphics.Rectangle();
		_cell.setDimension(new java.awt.Dimension(50,50));
		_cell.setCenterLocation(new java.awt.Point(125,150));
		_cell.setColor(utilities.Random.randomColor());
		_canvas.add(_cell);
		
		_stainTimer = new StainTimer(500);
		_growthTimer = new GrowthTimer(400);
		_deathTimer = new DeathTimer(1000);
	}

	/**
	 * @see lab3lib.ICell#grow()
	 */
	public void grow() {
		_growthTimer.start();
	}

	/**
	 * @see lab3lib.ICell#stain(graphics.colors.Color)
	 * @param color
	 */
	public void stain(graphics.colors.Color color) {
		_cell.setColor((java.awt.Color)color);
		_stainTimer.start();
	}

	/**
	 * @see lab3lib.ICell#die()
	 */
	public void die() {
		_deathTimer.start();
	}

	/**
	 * Timer to control animation of the growing cell
	 *
	 * @author <a href="mailto:alphonce@cse.buffalo.edu">Carl Alphonce</a>
	 *
	 * Created on: Sep 16, 2006
	 *
	 */
	private class GrowthTimer extends utilities.Timer {
		
		
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public GrowthTimer(int delay) {
			super(delay);
		}
				
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
			java.awt.Dimension dimension = _cell.getDimension();
			
			int dim = dimension.height;
			
			dim += 3;
			
			if(dim > 250) {
				dim = 250;
				_cell.setDimension(new java.awt.Dimension(dim, dim));
				_cell.setCenterLocation(new java.awt.Point(125, 150));
				this.stop();
			}
			else {
				_cell.setDimension(new java.awt.Dimension(dim, dim));
				_cell.setCenterLocation(new java.awt.Point(125, 150));
			}	
		}
	}
	
	/**
	 * Timer to control the death of the cell
	 *
	 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
	 *
	 * Created on: Sep 24, 2006
	 *
	 */
	private class DeathTimer extends utilities.Timer {
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public DeathTimer(int delay) {
			super(delay);
		}
				
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
			
			java.awt.Dimension dimension = _cell.getDimension();
			
			int dim = dimension.height;
			
			dim -= 2;
			
			if(dim < 1) {
				dim = 1;
				_cell.setDimension(new java.awt.Dimension(dim, dim));
				_cell.setCenterLocation(new java.awt.Point(125, 150));
				_cell.setColor(java.awt.Color.BLACK);
				this.stop();
			}
			else {
				_cell.setDimension(new java.awt.Dimension(dim, dim));
				_cell.setCenterLocation(new java.awt.Point(125, 150));
			}
			
		}
	}
	
	/**
	 * Timer to control the staining of the cell
	 *
	 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
	 *
	 * Created on: Sep 24, 2006
	 *
	 */
	private class StainTimer extends utilities.Timer {
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public StainTimer(int delay) {
			super(delay);
		}
				
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
			int red = _canvas.getColor().getRed();
			
			java.awt.Color newColor;
			if(red>=5)
				newColor = new java.awt.Color(red-5, red-5, red-5);
			else{
				newColor = new java.awt.Color(0, 0, 0);
				this.stop();
			}
			
			_canvas.setColor(newColor);
			
		}
	}
}
