package lab3lib;


/**
 * An unidentified cell that we can observe in our Cell Observation Room.
 *
 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
 *
 * Created on: Sep 24, 2006
 *
 */
public class UnidentifiedCellC implements ICell {

	private graphics.Rectangle _firstCell;
	private graphics.Rectangle _cr1, _cr2, _cr3, _cr4;
	private graphics.Polygon _triangle, _square, _pent, _hex, _oct;
	private StainTimer _stainTimer;
	private GrowthTimer _growthTimer;
	private DeathTimer _deathTimer;
	
	private graphics.DrawingCanvas _canvas;
	
	/**
	 * Creates a new instance of UnidentifiedCellC
	 * @param canvas
	 */
	public UnidentifiedCellC(graphics.DrawingCanvas canvas) {
		
		_canvas = canvas;
		
		_firstCell = new graphics.Rectangle();
		_firstCell.setDimension(new java.awt.Dimension(30,10));
		_firstCell.setCenterLocation(new java.awt.Point(125,150));
		_firstCell.setColor(utilities.Random.randomColor());
		
		this.makeConcentricRectangles();
		_canvas.add(_firstCell);
		
		_triangle = new graphics.Polygon();
		_triangle.setDimension(new java.awt.Dimension(60,60));
		_triangle.setCenterLocation(new java.awt.Point(125,150));
		_triangle.addPoint(new java.awt.Point(125,120));
		_triangle.addPoint(new java.awt.Point(95, 180));
		_triangle.addPoint(new java.awt.Point(155, 180));
		_triangle.setColor(_canvas.getColor());
		
		_square = new graphics.Polygon();
		_square.setDimension(new java.awt.Dimension(120,120));
		_square.setCenterLocation(new java.awt.Point(125,150));
		_square.addPoint(new java.awt.Point(65,90));
		_square.addPoint(new java.awt.Point(65,210));
		_square.addPoint(new java.awt.Point(185,210));
		_square.addPoint(new java.awt.Point(185,90));
		_square.setColor(_canvas.getColor());
		
		_pent = new graphics.Polygon();
		_pent.setDimension(new java.awt.Dimension(240,240));
		_pent.addPoint(new java.awt.Point(5,150));
		_pent.addPoint(new java.awt.Point(5,270));
		_pent.addPoint(new java.awt.Point(245,270));
		_pent.addPoint(new java.awt.Point(245,150));
		_pent.addPoint(new java.awt.Point(125,30));
		_pent.setColor(_canvas.getColor());
		
		_hex = new graphics.Polygon();
		_hex.setDimension(new java.awt.Dimension(240,240));
		_hex.setCenterLocation(new java.awt.Point(125,150));
		_hex.addPoint(new java.awt.Point(5,80));
		_hex.addPoint(new java.awt.Point(5,200));
		_hex.addPoint(new java.awt.Point(125,270));
		_hex.addPoint(new java.awt.Point(245,200));
		_hex.addPoint(new java.awt.Point(245,80));
		_hex.addPoint(new java.awt.Point(125,30));
		_hex.setColor(_canvas.getColor());
		
		_oct = new graphics.Polygon();
		_oct.setDimension(new java.awt.Dimension(240,240));
		_oct.setCenterLocation(new java.awt.Point(125,150));
		_oct.addPoint(new java.awt.Point(5,90));
		_oct.addPoint(new java.awt.Point(5,210));
		_oct.addPoint(new java.awt.Point(65,270));
		_oct.addPoint(new java.awt.Point(185,270));
		_oct.addPoint(new java.awt.Point(245,210));
		_oct.addPoint(new java.awt.Point(245,90));
		_oct.addPoint(new java.awt.Point(185,30));
		_oct.addPoint(new java.awt.Point(65,30));
		_oct.setColor(_canvas.getColor());
		
		_stainTimer = new StainTimer(500);
		_growthTimer = new GrowthTimer(400);
		_deathTimer = new DeathTimer(1000);
	}

	private void makeConcentricRectangles() {
		_cr1 = new graphics.Rectangle();
		_cr2 = new graphics.Rectangle();
		_cr3 = new graphics.Rectangle();
		_cr4 = new graphics.Rectangle();
		
		_cr1.setDimension(new java.awt.Dimension(80, 20));
		_cr2.setDimension(new java.awt.Dimension(130, 40));
		_cr3.setDimension(new java.awt.Dimension(180, 80));
		_cr4.setDimension(new java.awt.Dimension(230, 160));
		
		_cr1.setCenterLocation(new java.awt.Point(125, 150));
		_cr2.setCenterLocation(new java.awt.Point(125, 150));
		_cr3.setCenterLocation(new java.awt.Point(125, 150));
		_cr4.setCenterLocation(new java.awt.Point(125, 150));
		
		_cr1.setColor(_canvas.getColor());
		_cr2.setColor(_canvas.getColor());
		_cr3.setColor(_canvas.getColor());
		_cr4.setColor(_canvas.getColor());
		
		_canvas.add(_cr4);
		_canvas.add(_cr3);
		_canvas.add(_cr2);
		_canvas.add(_cr1);
	}
	
	/**
	 * @see lab3lib.ICell#grow()
	 */
	public void grow() {
		_growthTimer.start();
	}

	/**
	 * @see lab3lib.ICell#stain(graphics.colors.Color)
	 * @param color
	 */
	public void stain(graphics.colors.Color color) {
		_firstCell.setColor((java.awt.Color)color);
		_stainTimer.setInnerColor((java.awt.Color)color);
		_stainTimer.start();
	}

	/**
	 * @see lab3lib.ICell#die()
	 */
	public void die() {
		_deathTimer.start();
	}

	/**
	 * Timer to control animation of the growing cell
	 *
	 * @author <a href="mailto:alphonce@cse.buffalo.edu">Carl Alphonce</a>
	 *
	 * Created on: Sep 16, 2006
	 *
	 */
	private class GrowthTimer extends utilities.Timer {
		
		private int _whichShape;
		
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public GrowthTimer(int delay) {
			super(delay);
			_whichShape = 0;
		}
				
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
//			The gods of OO will have to forgive me for this - I'm short on time, and not
			//sure if you can have inner-interfaces and such
			switch(_whichShape) {
			case 0:
				_firstCell.setColor(utilities.Random.randomColor());
				_whichShape++;
				break;
			case 1:
				_firstCell.setColor(_canvas.getColor());
				_triangle.setColor(utilities.Random.randomColor());
				_canvas.add(_triangle);
				_whichShape++;
				break;
			case 2:
				_triangle.setColor(_canvas.getColor());
				_square.setColor(utilities.Random.randomColor());
				_canvas.add(_square);
				_whichShape++;
				break;
			case 3:
				_square.setColor(_canvas.getColor());
				_pent.setColor(utilities.Random.randomColor());
				_canvas.add(_pent);
				_whichShape++;
				break;
			case 4:
				_pent.setColor(_canvas.getColor());
				_hex.setColor(utilities.Random.randomColor());
				_canvas.add(_hex);
				_whichShape++;
				break;
			case 5:
				_hex.setColor(_canvas.getColor());
				_oct.setColor(utilities.Random.randomColor());
				_canvas.add(_oct);
				_whichShape++;
				break;
			default:
				this.stop();
				break;
			}
		}
	}
	
	/**
	 * Timer to control the death of the cell
	 *
	 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
	 *
	 * Created on: Sep 24, 2006
	 *
	 */
	private class DeathTimer extends utilities.Timer {
		
		private int _whichRec;
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public DeathTimer(int delay) {
			super(delay);
			_whichRec = 1;
		}
			
		
		private void blowUp() {
			_firstCell.setColor(_canvas.getColor());
			_cr1.setColor(_canvas.getColor());
			_cr2.setColor(_canvas.getColor());
			_cr3.setColor(_canvas.getColor());
			_cr4.setColor(_canvas.getColor());
			
			java.awt.Color blowUpColor = utilities.Random.randomColor();
			for(int i = 0; i <= 100; i++ ) {
				graphics.Rectangle rec = new graphics.Rectangle();
				rec.setDimension(new java.awt.Dimension(5,5));
				rec.setLocation(containers.Lab3Applet.RIGHTPANEL.randomPoint());
				rec.setColor(blowUpColor);
				
				_canvas.add(rec);
			}
			
		}
		
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
			
//			The gods of OO will have to forgive me for this - I'm short on time, and not
			//sure if you can have inner-interfaces and such
			switch(_whichRec) {
			case 1:
				_cr1.setColor(utilities.Random.randomColor());
				_whichRec++;
				break;
			case 2:
				_cr2.setColor(utilities.Random.randomColor());
				_whichRec++;
				break;
			case 3:
				_cr3.setColor(utilities.Random.randomColor());
				_whichRec++;
				break;
			case 4:
				_cr4.setColor(utilities.Random.randomColor());
				_whichRec++;
				break;
			default:
				this.blowUp();
				this.stop();
				break;
			}
			
		}
	}
	
	/**
	 * Timer to control the staining of the cell
	 *
	 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne Decker</a>
	 *
	 * Created on: Sep 24, 2006
	 *
	 */
	private class StainTimer extends utilities.Timer {
		
		private int _whichRec;
		private java.awt.Color _innerColor;
		
		/**
		 * Creates a new instance of Timer
		 * @param delay The amount of the delay for the timer.
		 */
		public StainTimer(int delay) {
			super(delay);
			_whichRec = 1;
		}
		
		public void setInnerColor(java.awt.Color c) {
			_innerColor = c;
		}
			
		private java.awt.Color getNextColor(java.awt.Color input) {
			
			int red = input.getRed();
			int green = input.getGreen();
			int blue = input.getBlue();
			
			red = Math.max((int) (red * 0.9), 0);
			green = Math.max((int) (green * 0.9), 0);
			blue = Math.max((int) (blue * 0.9), 0);
			
			return new java.awt.Color(red, green, blue);
		}
		/**
		 * @see utilities.Timer#activate()
		 */
		@Override
		public void activate() {
			
			//The gods of OO will have to forgive me for this - I'm short on time, and not
			//sure if you can have inner-interfaces and such
			switch(_whichRec) {
			case 1:
				_cr1.setColor(this.getNextColor(_innerColor));
				_whichRec++;
				break;
			case 2:
				_cr2.setColor(this.getNextColor(_cr1.getColor()));
				_whichRec++;
				break;
			case 3:
				_cr3.setColor(this.getNextColor(_cr2.getColor()));
				_whichRec++;
				break;
			case 4:
				_cr4.setColor(this.getNextColor(_cr3.getColor()));
				_whichRec++;
				break;
			default:
				this.stop();
				break;
			}
			
		}
	}
}
