/**
 * Contains the library files needed to complete Lab 5.
 */
package lab5lib;

import graphics.IContainer;
import graphics.IGraphic;
import graphics.movement.IGraphicMovement;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;

import utilities.Timer;
import utilities.Vector;

/**
 * A composite shape that contains a circle, square and oval.
 *
 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne M Decker</a>
 *
 * Created on: Feb 16, 2007
 *
 */
public class TripleShape implements graphics.IGraphic {

	/**
	 * The compound graphic that will actually be manipulated.
	 */
	private graphics.CompoundGraphic _shape;
	/**
	 * The square that is a component of this composite.
	 */
	private graphics.Rectangle _square;
	/**
	 * The circle that is a component of this composite.
	 */
	private graphics.Ellipse _circle;
	/**
	 * The ellipse/oval that is a component of this composite.
	 */
	private graphics.Ellipse _oval;
	/**
	 * The timer that controls the animation if set for this composite.
	 */
	private utilities.Timer _timer;
	/**
	 * The vector for the direction of motion of the entire composite.
	 */
	private utilities.Vector _directionVector;
	
	/**
	 * Creates a new instance of ManipulatableCompositeShape
	 */
	public TripleShape() {
		_shape = new graphics.CompoundGraphic();
		this.setDimension(new java.awt.Dimension(85,80));
		this.createShape();
		
		_directionVector = new utilities.Vector(4,4);
		
		_timer = new Timer(1){
			@Override
			public void activate() {
				_directionVector = _shape.move(_directionVector);
			}
		};
	}
	
	/**
	 * Starts the motion of this graphic.
	 */
	public void startMotion() {
		_timer.start();
	}
	
	/**
	 * Stops the motion of this graphic.
	 */
	public void stopMotion() {
		_timer.stop();
	}
	
	/**
	 * Set the dimension of the square only from the composite.
	 * @param newSize The new size to make the square.
	 */
	public void setDimensionSquare(java.awt.Dimension newSize) {
		_square.setDimension(newSize);
	}
	
	/**
	 * Set the dimension of the circle only from this composite.
	 * @param newSize The new size to make the circle.
	 */
	public void setDimensionCircle(java.awt.Dimension newSize) {
		_circle.setDimension(newSize);
	}
	
	/**
	 * Set the dimension of the oval only from this composite.
	 * @param newSize The new size to make the oval.
	 */
	public void setDimensionOval(java.awt.Dimension newSize) {
		_oval.setDimension(newSize);
	}
	
	/**
	 * Set the location of the circle only from this composite.
	 * @param newLocation The new location for the circle.
	 */
	public void setLocationCircle(java.awt.Point newLocation) {
		_circle.setLocation(newLocation);
	}

	/**
	 * Set the location of the oval only from this composite.
	 * @param newLocation The new location for the oval.
	 */
	public void setLocationOval(java.awt.Point newLocation) {
		_oval.setLocation(newLocation);
	}
	
	/**
	 * Set the location of the square only from this composite.
	 * @param newLocation The new location of the square.
	 */
	public void setLocationSquare(java.awt.Point newLocation) {
		_square.setLocation(newLocation);
	}
	
	/**
	 * Set the rotation of the oval only from this composite.
	 * @param newRotationAngle The number of degrees to rotate the oval.
	 */
	public void setRotationOval(java.lang.Integer newRotationAngle) {
		_oval.setRotation(newRotationAngle);
	}
	
	/**
	 * Set the rotation of the square only from this composite.
	 * @param newRotationAngle The number of degrees to rotate the square.
	 */
	public void setRotationSquare(java.lang.Integer newRotationAngle) {
		_square.setRotation(newRotationAngle);
	}
	
	/**
	 * Set the color of the square only from this composite.
	 * @param newColor The new color for the square.
	 */
	public void setColorSquare(graphics.colors.Color newColor){
		_square.setColor(newColor);
	}
	
	/**
	 * Set the color of the circle only from this composite.
	 * @param newColor The new color for the circle.
	 */
	public void setColorCircle(graphics.colors.Color newColor){
		_circle.setColor(newColor);
	}
	
	/**
	 * Set the color of the oval only from this composite.
	 * @param newColor The new color for the oval.
	 */
	public void setColorOval(graphics.colors.Color newColor){
		_oval.setColor(newColor);
	}
	
	/**
	 * Set the directional vector for the entire composite shape.
	 * @param newVector The new directional vector.
	 */
	public void setDirectionVector(utilities.Vector newVector) {
		_directionVector = newVector;
	}
	
	/**
	 * Creates the individual shapes of the composite.
	 */
	private void createShape() {
		_square = new graphics.Rectangle();
		_square.setDimension(new java.awt.Dimension(50,50));
		_square.setLocation(new java.awt.Point(0,0));
		_square.setColor(new graphics.colors.Magenta());
		_shape.add(_square);
		
		_circle = new graphics.Ellipse();
		_circle.setDimension(new java.awt.Dimension(30,30));
		_circle.setLocation(new java.awt.Point(50,50));
		_circle.setColor(new graphics.colors.Yellow());
		_shape.add(_circle);
		
		_oval = new graphics.Ellipse();
		_oval.setDimension(new java.awt.Dimension(40,20));
		_oval.setLocation(new java.awt.Point(45, 33));
		_oval.setColor(new graphics.colors.Green());
		_shape.add(_oval);
		
		
	}
	
	/**
	 * @see graphics.IGraphic#actualPaint(java.awt.Graphics2D, java.awt.Point, java.awt.Dimension)
	 * @param gs
	 * @param location
	 * @param dimension
	 */
	public void actualPaint(Graphics2D gs, Point location, Dimension dimension) {
		_shape.actualPaint(gs, location, dimension);
	}

	/**
	 * @see graphics.IGraphic#addMouseListener(java.awt.event.MouseListener)
	 * @param ml
	 */
	public void addMouseListener(MouseListener ml) {
		_shape.addMouseListener(ml);
	}

	/**
	 * @see graphics.IGraphic#addMouseMotionListener(java.awt.event.MouseMotionListener)
	 * @param mml
	 */
	public void addMouseMotionListener(MouseMotionListener mml) {
		_shape.addMouseMotionListener(mml);
	}

	/**
	 * @see graphics.IGraphic#contains(java.awt.Point)
	 * @param p
	 * @return
	 */
	public boolean contains(Point p) {
		return _shape.contains(p);
	}

	/**
	 * @see graphics.IGraphic#getBounds()
	 * @return
	 */
	public Rectangle getBounds() {
		return _shape.getBounds();
	}

	/**
	 * @see graphics.IGraphic#getContainer()
	 * @return
	 */
	public IContainer getContainer() {
		return _shape.getContainer();
	}

	/**
	 * @see graphics.IGraphic#getMouseListeners()
	 * @return
	 */
	public Collection<MouseListener> getMouseListeners() {
		return _shape.getMouseListeners();
	}

	/**
	 * @see graphics.IGraphic#getMouseMotionListeners()
	 * @return
	 */
	public Collection<MouseMotionListener> getMouseMotionListeners() {
		return _shape.getMouseMotionListeners();
	}

	/**
	 * @see graphics.IGraphic#getShape()
	 * @return
	 */
	public Shape getShape() {
		return _shape.getShape();
	}

	/**
	 * @see graphics.IGraphic#intersects(graphics.IGraphic)
	 * @param shape
	 * @return
	 */
	public boolean intersects(IGraphic shape) {
		return _shape.intersects(shape);
	}

	/**
	 * @see graphics.IGraphic#paint(java.awt.Graphics2D)
	 * @param gs
	 */
	public void paint(Graphics2D gs) {
		_shape.paint(gs);
	}

	/**
	 * @see graphics.IGraphic#setContainer(graphics.IContainer)
	 * @param container
	 */
	public void setContainer(IContainer container) {
		_shape.setContainer(container);
	}

	/**
	 * @see graphics.IGraphic#setMovement(graphics.movement.IGraphicMovement)
	 * @param movement
	 */
	public void setMovement(IGraphicMovement movement) {
		_shape.setMovement(movement);
	}

	/**
	 * @see graphics.ISizeable#getDimension()
	 * @return
	 */
	public Dimension getDimension() {
		return _shape.getDimension();
	}

	/**
	 * @see graphics.ISizeable#setDimension(java.awt.Dimension)
	 * @param d
	 */
	public void setDimension(Dimension d) {
		_shape.setDimension(d);
	}

	/**
	 * @see graphics.CenterLocatable#getCenterLocation()
	 * @return
	 */
	public Point getCenterLocation() {
		return _shape.getCenterLocation();
	}

	/**
	 * @see graphics.CenterLocatable#setCenterLocation(java.awt.Point)
	 * @param p
	 */
	public void setCenterLocation(Point p) {
		_shape.setCenterLocation(p);
	}

	/**
	 * @see graphics.ILocatable#getLocation()
	 * @return
	 */
	public Point getLocation() {
		return _shape.getLocation();
	}

	/**
	 * @see graphics.ILocatable#move(utilities.Vector)
	 * @param v
	 * @return
	 */
	public Vector move(Vector v) {
		return _shape.move(v);
	}

	/**
	 * @see graphics.ILocatable#setLocation(java.awt.Point)
	 * @param p
	 */
	public void setLocation(Point p) {
		_shape.setLocation(p);
	}

	/**
	 * @see graphics.IRotatable#getRotation()
	 * @return
	 */
	public Integer getRotation() {
		return _shape.getRotation();
	}

	/**
	 * @see graphics.IRotatable#rotate(java.lang.Integer)
	 * @param degreesToRotate
	 */
	public void rotate(Integer degreesToRotate) {
		_shape.rotate(degreesToRotate);
	}

	/**
	 * @see graphics.IRotatable#setRotation(java.lang.Integer)
	 * @param degree
	 */
	public void setRotation(Integer degree) {
		_shape.setRotation(degree);
	}

	/**
	 * @see graphics.IGraphic#getMovement()
	 * @return
	 */
	public IGraphicMovement getMovement() {
		return _shape.getMovement();
	}

}
