package lab6lib;

/**
 * A class that creates Karel the robot and allows the user to move Karel.
 * 
 * @author <a href="mailto:adrienne@cse.buffalo.edu">Adrienne M Decker</a>
 * 
 * Created on: Feb 22, 2007
 * 
 */
public class Karel {

	/**
	 * The drawing canvas that Karel is located on.
	 */
	private graphics.DrawingCanvas _drawingCanvas;

	/**
	 * The image that represents Karel.
	 */
	private graphics.Image _karel;

	/**
	 * The direction that Karel is currently facing.
	 */
	private utilities.Vector _directionVector;

	/**
	 * Creates a new instance of Karel. Karel's dimension is 61 pixels wide by
	 * 113 pixels tall.
	 */
	public Karel() {
		// Default is to start Karel facing East.
		_karel = new graphics.Image("KarelEast.GIF");
		_karel.setDimension(new java.awt.Dimension(61, 113));
		// Allow Karel to wrap around the edges of the screen.
		_karel.setMovement(new graphics.movement.WrappingMovement());
		// Set Vector to East
		_directionVector = EAST;
	}

	/**
	 * In order to see Karel, you must add him to a graphics.DrawingCanvas at a
	 * particular point.
	 * 
	 * @param canvas
	 *            The DrawingCanvas to put Karel upon.
	 * @param startingPoint
	 *            The point where Karel should first be located.
	 */
	public void addToDrawingCanvas(graphics.DrawingCanvas canvas,
			java.awt.Point startingPoint) {
		_drawingCanvas = canvas;
		_drawingCanvas.add(_karel);
		_karel.setLocation(startingPoint);
	}

	/**
	 * Tells Karel to face North. No matter what direction Karel was previously,
	 * he will turn to face North if this method is called.
	 */
	public void faceNorth() {
		if (_drawingCanvas != null) {
			java.awt.Point location = _karel.getLocation();
			// To ease the Image stuff, first remove Karel from the canvas
			_drawingCanvas.remove(_karel);
			// Then create a new Karel facing the proper direction, and with
			// proper size, location, motion.
			_karel = new graphics.Image("KarelNorth.GIF");
			_karel.setDimension(new java.awt.Dimension(61, 113));
			_karel.setMovement(new graphics.movement.WrappingMovement());
			_karel.setLocation(location);
			// And add him back onto the canvas
			_drawingCanvas.add(_karel);
			// Update direction Vector.
			_directionVector = NORTH;
		}
	}

	/**
	 * Tells Karel to face South. No matter what direction Karel was previously,
	 * he will turn to face South if this method is called.
	 */
	public void faceSouth() {
		if (_drawingCanvas != null) {
			java.awt.Point location = _karel.getLocation();
			_drawingCanvas.remove(_karel);
			_karel = new graphics.Image("KarelSouth.GIF");
			_karel.setDimension(new java.awt.Dimension(61, 113));
			_karel.setMovement(new graphics.movement.WrappingMovement());
			_karel.setLocation(location);
			_drawingCanvas.add(_karel);
			_directionVector = SOUTH;
		}
	}

	/**
	 * Tells Karel to face East. No matter what direction Karel was previously,
	 * he will turn to face East if this method is called.
	 */
	public void faceEast() {
		if (_drawingCanvas != null) {
			java.awt.Point location = _karel.getLocation();
			_drawingCanvas.remove(_karel);
			_karel = new graphics.Image("KarelEast.GIF");
			_karel.setDimension(new java.awt.Dimension(61, 113));
			_karel.setMovement(new graphics.movement.WrappingMovement());
			_karel.setLocation(location);
			_drawingCanvas.add(_karel);
			_directionVector = EAST;
		}
	}

	/**
	 * Tells Karel to face West. No matter what direction Karel was previously,
	 * he will turn to face West if this method is called.
	 */
	public void faceWest() {
		if (_drawingCanvas != null) {
			java.awt.Point location = _karel.getLocation();
			_drawingCanvas.remove(_karel);
			_karel = new graphics.Image("KarelWest.GIF");
			_karel.setDimension(new java.awt.Dimension(61, 113));
			_karel.setMovement(new graphics.movement.WrappingMovement());
			_karel.setLocation(location);
			_drawingCanvas.add(_karel);
			_directionVector = WEST;
		}
	}

	/**
	 * Tell Karel to move in his current direction a specified number of steps.
	 * Each one of Karel's steps is equivalent to 10 pixels.
	 * 
	 * @param numberOfSteps
	 *            The number of steps Karel should move.
	 */
	public void move(Integer numberOfSteps) {
		utilities.Vector newVector = new utilities.Vector(_directionVector
				.getDx()
				* numberOfSteps, _directionVector.getDy() * numberOfSteps);
		_karel.move(newVector);
	}

	/**
	 * A Vector representing one step of movement in the East direction.
	 */
	private final utilities.Vector EAST = new utilities.Vector(10, 0);

	/**
	 * A Vector representing one step of movement in the West direction.
	 */
	private final utilities.Vector WEST = new utilities.Vector(-10, 0);

	/**
	 * A Vector representing one step of movement in the North direction.
	 */
	private final utilities.Vector NORTH = new utilities.Vector(0, -10);

	/**
	 * A Vector representing one step of movement in the South direction.
	 */
	private final utilities.Vector SOUTH = new utilities.Vector(0, 10);
}
