//<PLAINTEXT>
package lab6lib;
/**
 * A class that represents the Turtle from LOGO.  Turtle can be told how to move and to rotate.
 *
 *
 * Created: Mon Nov 27 21:08:21 2000
 *
 * @author <a href="mailto: ">Phil Ventura, modified by Adrienne Decker</a>
 * @version
 */

public class Turtle {

	/**
	 * The main body of the turtle.
	 */
	private graphics.Ellipse _body;
	
	/**
	 * Since the turtle is an ellipse, the head piece indicates direction.
	 */
	private graphics.Ellipse _head;
	

	/**
	 * Creates a new instance of Turtle.  The turtle will have a dimension of approximately 14 pixels by 14 pixels
	 * and will appear the color black.  It will first appear heading North.
	 */
	public Turtle(){
		_head = new graphics.Ellipse();
		_body = new graphics.Ellipse();
		_head.setDimension(new java.awt.Dimension(4,4));
		_body.setDimension(new java.awt.Dimension(10,10));
		_head.setColor(new graphics.colors.Black());
		_body.setColor(new graphics.colors.Black());
		//Default is 0, which is East.  I want the turtle to face North by default.
		_body.setRotation(90);
	}

	/**
	 * Adds the turtle to the drawing canvas specified at the point specified.
	 * @param canvas The DrawingCanvas to add the turtle to.
	 * @param startingPoint The point where the turtle should be first located.
	 */
	public void addToDrawingCanvas(graphics.DrawingCanvas canvas, java.awt.Point startingPoint) {
		canvas.add(_body);
		canvas.add(_head);
		_body.setLocation(startingPoint);
		if(_head != null) {
			this.repositionHead();
		}
	}

	/**
	 * Rotate the turtle to this degree.  Zero(0) degrees is north, 90 is west, 180 is south
	 * and 270 is east.
	 * @param degrees The degree heading to set the turtle facing.
	 */
	public void rotate(Integer degrees) {
		_body.setRotation(degrees+90);

		if(_head != null ) {
			this.repositionHead();
		}
	}

	/**
	 * Moves the turtle forward a specific number of steps in the current direction it is facing.
	 * Steps for the turtle are each two pixels long.
	 * @param numberOfSteps The number of steps the turtle should move.
	 */
	public void moveForward(Integer numberOfSteps) {
		this.move(numberOfSteps);
	}

	/**
	 * This method actually does the moving.  It used to draw a line as the turtle
	 * moved as well, but that was taken out for Lab 6.
	 * 
	 * @param numberOfSteps The number of steps to move in the current direction.
	 */
	private void move(int numberOfSteps) {

		// move
		_body.setLocation(new
				java.awt.Point(newX(_body.getLocation().x, _body.getRotation(),
						numberOfSteps * 2),
						newY(_body.getLocation().y, _body.getRotation(),
								numberOfSteps * 2)));
		if(_head != null ) {
			this.repositionHead();
		}
	}

	/**
	 * Repositions the head so it always indicates which direciton the turtle is facing.
	 */
	private void repositionHead() {
		java.awt.Point ctr = _body.getCenterLocation();
		int rot = _body.getRotation();
		int dist = _body.getDimension().width / 2 +
		_head.getDimension().width / 2;
		_head.setCenterLocation(new
				java.awt.Point(newX(ctr.x, rot, dist),
						newY(ctr.y, rot, dist)));
	}



	/**
	 * Used by repositionHead to get the new x coordinate.  Phil wrote it.
	 * @param x
	 * @param alpha
	 * @param length
	 * @return
	 */
	private static int newX(double x, int alpha, double length) {
		return (int) Math.round(  x
				+ Math.cos(degreesToRadians(alpha))
				* length);
	}

	/**
	 * Used by repositionHead to get the new y coordinate.  Phil wrote it.
	 * @param y
	 * @param alpha
	 * @param length
	 * @return
	 */
	private static int newY(double y, int alpha, double length) {
		return (int) Math.round(  y
				- Math.sin(degreesToRadians(alpha))
				* length);
	}

	/**
	 * Convert a value in degrees to radians.
	 * @param degrees The value in degrees.
	 * @return The value passed in as degrees as radians.
	 */
	private static double degreesToRadians(double degrees) {
		return (Math.PI * degrees / 180.0);
	}

}// Turtle
