package physics;

/**
 * CollisionGroup.java
 *
 *
 * Created: Saturday September 18 11:45:51 2004
 *
 * @author <a href= mailto:"Sara@cse.buffalo.edu" </a>
 * @version
 *
 * This class stores the Collision Objects that collide with eachother
 */

import java.util.ArrayList;

import graphics.DrawingCanvas;
import graphics.Rectangle;

public class CollisionGroup {

	private ArrayList<CollisionObject> _group;

	private DrawingCanvas _dp;

	/**
	 * Creates a new <code>CollisionGroup</code> instance.
	 * 
	 * @param dp
	 *            a <code>NGP.Containers.DrawingPanel</code> that the
	 *            Collision Objects of this group are on
	 */
	public CollisionGroup(DrawingCanvas dp) {
		_group = new ArrayList<CollisionObject>();
		_dp = dp;
	}

	/**
	 * Adds a CollisionObject to the CollisionGroup
	 * 
	 * @param co
	 *            a <code>CollisionObject</code> to add to the group
	 */
	public void add(CollisionObject co) {
		_group.add(co);
		co.setGroup(this);
	}

	/**
	 * Returns the Arraylist containing the CollsionObjects
	 * 
	 * @return an <code>ArrayList</code> containing the CollisionObjects in
	 *         this group
	 */
	public ArrayList getGroup() {
		return _group;
	}

	/**
	 * Removes the CollisionObject from the group
	 * 
	 * @param co
	 *            a <code>CollisionObject</code> to be removed
	 */
	public void remove(CollisionObject co) {
		if (_group.contains(co)) {
			int index = _group.indexOf(co);
			_group.remove(index);
		} // end of if ()

	}

	/**
	 * Adds the North Wall to the Collision Group
	 */
	public void addNorthWall() {
		java.awt.Dimension d = _dp.getDimension();
		Rectangle fr = new Rectangle();
		_dp.add(fr);
		fr.setDimension(new java.awt.Dimension(d.width, 1));
		fr.setColor(_dp.getColor());
		fr.setLocation(new java.awt.Point(0, 0));
		CollisionObject cobj = new CollisionObject(fr);
		cobj.setWall(true);
		this.add(cobj);
	}

	/**
	 * Adds the South Wall to the Collision Group
	 */
	public void addSouthWall() {
		java.awt.Dimension d = _dp.getDimension();
		Rectangle fr = new Rectangle();
		_dp.add(fr);
		fr.setDimension(new java.awt.Dimension(d.width, 1));
		fr.setColor(_dp.getColor());
		fr.setLocation(new java.awt.Point(0, d.height - 1));
		CollisionObject cobj = new CollisionObject(fr);
		cobj.setWall(true);
		cobj.setSouthWall(true);
		this.add(cobj);
	}

	/**
	 * <code>addWestWall</code> Adds the West Wall to the Collision Group
	 */
	public void addWestWall() {
		java.awt.Dimension d = _dp.getDimension();
		Rectangle fr = new Rectangle();
		_dp.add(fr);

		// fr.setColor(java.awt.Color.MAGENTA);

		fr.setDimension(new java.awt.Dimension(1, d.height));
		fr.setColor(_dp.getColor());
		fr.setLocation(new java.awt.Point(0, 0));
		// fr.setLocation(new java.awt.Point(1,0));
		CollisionObject cobj = new CollisionObject(fr);
		cobj.setWall(true);
		this.add(cobj);
	}

	/**
	 * Adds the East Wall to the Collision Group
	 */
	public void addEastWall() {
		java.awt.Dimension d = _dp.getDimension();
		Rectangle fr = new Rectangle();
		_dp.add(fr);

		// fr.setColor(java.awt.Color.MAGENTA);

		fr.setDimension(new java.awt.Dimension(1, d.height));
		// fr.setColor(_dp.getColor());
		fr.setLocation(new java.awt.Point(d.width - 1, 0));
		CollisionObject cobj = new CollisionObject(fr);
		cobj.setWall(true);
		this.add(cobj);

	}

	/**
	 * Add all the walls to the Collision Group
	 */
	public void addAllWalls() {
		addWestWall();
		addEastWall();
		addSouthWall();
		addNorthWall();
	}

	/**
	 * Returns the DrawingPanel that the Collision Objects are on
	 * 
	 * @return a <code>NGP.Containers.DrawingPanel</code> that contains the
	 *         Collision Objects
	 */
	public DrawingCanvas getDP() {
		return _dp;
	}
}
