package physics;

/**
 * CollisionObject.java
 *
 *
 * Created: Saturday September 18 11:45:51 2004
 *
 * @author <a href= mailto:"Sara@cse.buffalo.edu" </a>
 * @version
 * A class that is able to collide and be part of a collision group
 */

import java.util.ArrayList;

import graphics.DrawingCanvas;


public class CollisionObject {

   private CollisionGroup _cg;
   private IMotion _motion;
   private graphics.IGraphic _shape;
   private int _mass;//, _xStartPoint, _yStartPoint;
   private CollisionObject _collidedObject;
   private boolean _wall,_collided;//, _verticalDirection, _horizontalDirection;
   private double _momentum;//, _velocity,_ellasticity;
   private LineFormula _line;
   private boolean _swall = false;
   private boolean _nwall = false;
   private boolean _ewall = false;
   private boolean _wwall = false;

   /**
    * Creates a new <code>CollisionObject</code> instance.
    *
    * @param shape a <code>NGP.Graphics.RectangularShape</code> to use
    * as the Shape
    */
   public CollisionObject(graphics.IGraphic shape){
      _shape = shape;
      _mass = _shape.getBounds().height * _shape.getBounds().width;
      //_ellasticity = .07;
      _wall = false; 
      _momentum = 0;
     // _xStartPoint = shape.getLocation().x;
    //  _yStartPoint = shape.getLocation().y;
      _motion = new NullMotion(this);
   }

   /**
    * Changes the collided boolean value to false
    * Must be overridden to do more
    */
   public void collisionReact(CollisionObject co){
    
      _collided = false;
      //System.out.println(_shape.getColor() + " " + System.currentTimeMillis());
   }


//   /**
//    * Set the Ellasticity
//    * @param e 
//    * an <code>int</code> 
//    */
//   public void setEllasticity(int e){
//	   _ellasticity = e;
//   }

   /**
    * Sets the SouthWall boolean value 
    * Set true if it is the SouthWall, false otherwise
    * @param bool
    */
   public void setSouthWall(boolean bool){
     _swall = bool;
       
   }
   
   /**
    * Sets the NorthWall boolean value 
    * Set true if it is the SouthWall, false otherwise
    * @param bool
    */
   public void setNorthWall(boolean bool){
     _nwall = bool;
       
   }
   
   /**
    * Sets the EastWall boolean value 
    * Set true if it is the SouthWall, false otherwise
    * @param bool
    */
   public void setEastWall(boolean bool){
     _ewall = bool;
       
   }
   
   /**
    * Sets the WestWall boolean value 
    * Set true if it is the SouthWall, false otherwise
    * @param bool
    */
   public void setWestWall(boolean bool){
     _wwall = bool;
       
   }
   
   /**
    * Gets the SouthWall boolean value
    * returns true if it is the SouthWall, false otherwise
    * @param bool
    */
   public boolean getSWall(){
      return _swall;
   }
   
   /**
    * Gets the NorthWall boolean value
    * returns true if it is the SouthWall, false otherwise
    * @param bool
    */
   public boolean getNWall(){
      return _nwall;
   }
   
   /**
    * Gets the EastWall boolean value
    * returns true if it is the SouthWall, false otherwise
    * @param bool
    */
   public boolean getEWall(){
      return _ewall;
   }
   
   /**
    * Gets the WestWall boolean value
    * returns true if it is the SouthWall, false otherwise
    * @param bool
    */
   public boolean getWWall(){
      return _wwall;
   }
   
   
   /**
    * Checks for a collision within the group
    */
   public void detectCollision(){
      if (!_wall) {
// 	 if (_cg == null) {
// 	    throw new CGException();
// 	 } // end of if ()
	 
	 ArrayList group = _cg.getGroup();
	 for (int i = 0; i < group.size(); i++) {
	 CollisionObject colOb = (CollisionObject)group.get(i);
	 if (!_shape.equals(colOb.getShape()) && _shape.intersects(colOb.getShape())) {
	    _collided = true;
	    _collidedObject = colOb;
	 } // end of if ()
	 } // end of for ()
     
	 if (_collided) {
	    this.collisionReact(_collidedObject);
	 } // end of if ()
	 }
   }


  
   /**
    * Sets the CollisionGroup for this Object
    * @param cg a <code>CollisionGroup</code>
    */
   public void setGroup(CollisionGroup cg){  
      _cg = cg;
   }


   /**
    * Returns whether the Object has collided with another object in
    * the current time interval
    * @return a <code>boolean</code> value
    */
   public boolean getCollided(){
      return _collided;
   }

   /**
    * Changes the motion for the object and starts the motion's timer
    * @param im an <code>IMotion</code>
    */
   public void setMotion(IMotion im){
      if (_motion != null) { 
	 _motion.stop();
	 _motion = im;
	 _motion.start();
      } // end of if ()
      else {
	 _motion = im;
	 _motion.start();
      } // end of else

      //Create a new LineFormula to be used for Transfer of Momentum
      if (_motion.getDX() > 0) {
	 _line = new LineFormula(_shape.getLocation(), _motion.getDY()/_motion.getDX()); 	 
      } // end of if ()
      else {
	 _line = new LineFormula(_shape.getLocation(),-1000); //-1000 as a default
      } // end of else
      
    
   }

   /**
    * Returns the shape of this object
    * @return a <code>NGP.Graphics.RectangularShape</code> 
    */
   public graphics.IGraphic getShape(){
      return _shape;
   }

   /**
    * Sets the shape for this collision object
    * @param rs a <code>NGP.Graphics.RectangularShape</code> 
    */
   public void setShape(graphics.IGraphic rs){
      _shape = rs;
   }

   /**
    * Returns the motion of this object
    * @return an <code>IMotion</code> 
    */
   public IMotion getMotion(){
      return _motion;
   }

   /**
    * <code>getDP</code> 
    * Returns the DrawingPanel this object is drawn upon
    * @return a <code>NGP.Containers.DrawingPanel</code> 
    */
   public DrawingCanvas getDP(){
      return _cg.getDP();
   }



   /**
    * Returns the calculated momentum using the mass and velocity of
    * the object
    * @return a <code>double</code> 
    */
   public double calculateMomentum(){
      _momentum = _motion.getVelocity() * _mass;
      return _momentum;
   }

   /**
    * Returns the Line that the object is traveling on
    * @return a <code>LineFormula</code> 
    */
   public LineFormula getLine(){
      return _line;
   }

   /**
    * Describe <code>setLine</code> 
    * Sets the line for the Collision Object
    * @param line a <code>LineFormula</code> 
    */
   public void setLine(LineFormula line){
      _line = line;
   }

   /**
    * Sets the mass of the object
    * @param mass an <code>int</code> 
    */
   public void setMass(int mass){
      _mass = mass;
   }

   /**
    * Returns the mass of the object
    * @return an <code>int</code> 
    */
   public int getMass(){
      return _mass;
   }


   /**
    * Set the boolean value describing if the object is a wall
    * @param b a <code>boolean</code>
    */
   public void setWall(boolean b){
      _wall = b;
   }
}
