package physics;

/**
 * FormulaSolver.java
 *
 *
 * Created: Sat Nov 20 16:51:27 2004
 *
 * @author <a href="mailto: "Sara M Haydanek</a>
 * @version
 * A class that solves the intersection points of two  <code>LineFormula</code>
 */

public class FormulaSolver {

   private LineFormula _l1, _l2;

   /**
    * Creates a new <code>FormulaSolver</code> instance.
    * @param l1 a <code>LineFormula</code> value
    * @param l2 a <code>LineFormula</code> value
    */
   public FormulaSolver (LineFormula l1, LineFormula l2){
      _l1 = l1;
      _l2 = l2;  
   }

   /**
    * Solves for the Y value of where the two lines intersect
    * @return a <code>double</code> 
    */
   public double solveY(){
      double x = this.solveX();
      x = _l1.getXCoeffcient() * x;
      return x + _l1.getY0();
   }

   /**
    * Solves for the X value of where the two lines intersect
    * @return a <code>double</code> value
    */
   public double solveX(){
      double x =  _l1.getXCoeffcient() - _l2.getXCoeffcient();
      double num = _l2.getY0() - _l1.getY0();
      return num/x;
   }
   
}// FormulaSolver
