package physics;

/**
 * GravityMotion.java
 * 
 * 
 * Created: Thu Nov 11 13:30:05 2004
 * 
 * @author <a href="mailto: "Sara M Haydanek</a>
 * @version A <code> IMotion </code> that mimics gravity
 */

public class GravityMotion extends IMotion {

	private int _gravitypixels;

	private int _dx, _dy, _speed;

	private CollisionObject _colOb;

	private MotionTimer _mt;

	// private double _mass;

	/**
	 * Creates a new <code>GravityMotion</code> instance.
	 * 
	 * @param colOb
	 *            a <code>CollisionObject</code> value
	 */
	public GravityMotion(CollisionObject colOb) {
		_gravitypixels = 3;
		_speed = 100;
		_dx = 10;
		_dy = 0;
		_colOb = colOb;
		// _mass = _colOb.getMass();
		_mt = new MotionTimer(_speed, this);
	}

	/*
	 * Sets the rate of Gravity @param g - rate in pixels
	 */
	@Override
	public void setGravity(int g) {
		_gravitypixels = g;

	}

	/**
	 * Sets the velocity of the motion
	 * 
	 * @param dx -
	 *            change in x direction
	 * @param dy -
	 *            change in y direction
	 * @param speed -
	 *            Timer delay
	 */
	@Override
	public void setVelocity(int dx, int dy, int speed) {
		_dx = dx;
		_dy = dy;
		_speed = speed;
	}

	/**
	 * Returns the speed of the motion
	 * 
	 * @return the timer delay
	 */
	@Override
	public int getSpeed() {
		return _speed;
	}

	/**
	 * Returns dx of the velocity
	 * 
	 * @return the change in x direction
	 */
	@Override
	public int getDX() {
		return _dx;
	}

	/**
	 * Returns dy of the velocity
	 * 
	 * @return the change in y direction
	 */
	@Override
	public int getDY() {
		return _dy;
	}

	/**
	 * Moves the object at intervals decided by the timer and checks for
	 * collisions
	 */
	@Override
	public void timerReact() {
		_colOb.getShape()
				.setCenterLocation(
						new java.awt.Point((_colOb.getShape()
								.getCenterLocation().x + _dx), (_colOb
								.getShape().getCenterLocation().y
								+ _dy + _gravitypixels)));
		_colOb.detectCollision();
	}

	/**
	 * Starts the MotionTimer for this motion
	 */
	@Override
	public void start() {
		_mt.start();
	}

	/**
	 * Stops the MotionTimer for this object
	 */
	@Override
	public void stop() {
		_mt.stop();
	}

	/**
	 * A bounce for this motion
	 */
	@Override
	public void bounce(CollisionObject co) {
		// java.awt.Point p = _colOb.getShape().getLocation();
		_dx = -_dx;
		_dy = -_dy;
		_colOb.getShape().setCenterLocation(
				new java.awt.Point(
						(_colOb.getShape().getCenterLocation().x + _dx),
						(_colOb.getShape().getCenterLocation().y + _dy)));
	}

	/**
	 * Set the DX direction
	 */
	@Override
	public void setDX(int dx) {
		_dx = dx;
	}

	/**
	 * Sets the DY direction
	 */
	@Override
	public void setDY(int dy) {
		_dy = dy;
	}

}// GravityMotion
