package physics;

  /**
  * IMotion.java
  *
  *
  * Created: Saturday September 18 11:45:51 2004
  *
  * @author <a href= mailto:"Sara@cse.buffalo.edu" </a>
  * @version
  * An abstract class for the  motion of a <code>CollisionObject</code>
  */




public abstract class IMotion {

   /**
    * Set the velocity of this motion
    * @param dx- change in the x direction
    * @param dy - change in the y direction
    * @param speed - the timer delay
    */
   public abstract void setVelocity(int dx, int dy, int speed);


   /**
    * Should return the DX value
    * @return change in the x direction
    */
   public abstract int getDX();

   /** 
    * Should change the DX value
    */
   public abstract void setDX(int dx);
   
   /**
    * Should change the DY value
    */
   public abstract void setDY(int dy);

   /**
    * Should return the DY value
    * @return change in the y direction
    */
   public abstract int getDY();

   /**
    * Should return the speed of this motion
    * @return the timer delay
    */
   public abstract int getSpeed();


   /**
    * Called when the timer reacts
    * Should be overridden to do something useful
    */
   public abstract void timerReact();

   /**
    * Should start the timer of this motion
    *
    */
   public abstract void start();

   /**
    * Should stop the timer of this motion
    */
   public abstract void stop();

   /**
    * Override to create a bounce for this motion when it collides
    * with col
    * @param col a <code>CollisionObject</code> value
    */
   public abstract void bounce(CollisionObject col);

   /**
    * Override to do something useful
    * @param c a <code>double</code> value
    */
   public void setCoefficient(double c){
   }

   /**
    * Override to do something useful
    * @return a <code>double</code> value
    */
   public double getVelocity(){
      return 0;
   }
   
   /**
    * Override to do something useful
    * @param d a <code>double</code> value
    */
   public void changeMomentum(double d){
   }

   /**
    * Override to do something useful
    * @param d a <code>double</code> value
    * @param c a <code>CollisionObject</code> value
    */
   public void switchMomentum(double d,CollisionObject c){
   }

   /**
    * Returns true, override to do something useful
    * @return a <code>boolean</code> value
    */
   public boolean getCollided(){
      return true;
   }

   /**
    * Override to do something useful
    * @param d a <code>double</code> value
    */
   public void setDX(double d){
   
   }

   /**
    * Override to do something useful
    * @param d a <code>double</code> value
    */
   public void setDY(double d){
   
   }

   /**
    * Override to do something useful 
    * @param d a <code>double</code> value
    * @param d2 a <code>double</code> value
    */
   public void setLocation(double d, double d2){
   }

   /**
    * Override to do something useful 
    * @param g an <code>int</code> value
    */
   public void setGravity(int g){
   }

}
