package physics;
/**
 * LineFormula.java
 *
 *
 * Created: Sat Nov 20 15:32:21 2004
 *
 * @author <a href="mailto: "Sara M Haydanek</a>
 * @version
 * A class representing a line
 */

public class LineFormula {

   private int _x, _y;
   private double _m;

   /**
    * Creates a new <code>LineFormula</code> instance.
    *
    * @param p a <code>java.awt.Point</code> value
    * @param m the y-intercept
    */
   public LineFormula (java.awt.Point p, double m){
      _x = p.x;
      _y = p.y;
      _m = m;
   }

   /**
    * Return the Y-axis intercept of this line
    * @return an <code>int</code> value
    */
   public int getYIntercept(){
      if (_m != -1000) {
      return (int)(_m*(-_x)) + _y;	 
      } // end of if ()
      else {
	 return _y;
      } // end of else
      
  
   }

   /**
    * Return the X-axis intercept 
    * @return a <code>double</code> value
    */
   public double getXIntercept(){
      if (_m != -1000) {
     return ((- getYIntercept())/_m);
   } // end of if ()
      else {
	 return _x;
      } // end of else
   }

   /**
    * Return the number of X's
    * @return a <code>double</code> value
    */
   public double getXCoeffcient(){
      return _m;
   }

   /**
    * Return the Intial Y value
    * @return an <code>int</code> value
    */
   public int getY0(){
      return _y;
   }

   /**
    * <code>getX0</code>
    * Return the intial X value
    * @return an <code>int</code> value
    */
   public int getX0(){
      return _x;
   }

}// LineFormula
