package physics;

/**
 * MotionTimer.java
 * 
 * 
 * Created: Sat Sep 18 19:48:45 2004
 * 
 * @author <a href="mailto: "Sara M Haydanek</a>
 * @version An extension of Timer tat interacts with an <code> IMotion </code>
 */

public class MotionTimer extends utilities.Timer {

	private IMotion _im;

	/**
	 * Creates a new <code>MotionTimer</code> instance.
	 * 
	 * @param delay
	 *            an <code>int</code> value
	 * @param im
	 *            an <code>IMotion</code> value
	 */
	public MotionTimer(int delay, IMotion im) {
		super(delay);
		_im = im;
	}

	/**
	 * Calls the motions TimerReact whenever the set time has expired
	 */
	@Override
	public void activate() {
		_im.timerReact();
	}

}// MotionTimer
