package physics;

/**
 * StraightMotion.java
 * 
 * 
 * Created: Sat Sep 18 20:30:34 2004
 * 
 * @author <a href="mailto: "Sara M Haydanek</a>
 * @version A motion that travels in straight lines
 */

public class StraightMotion extends IMotion {

//	private boolean _gravity;
	private int _dx;
	private int _dy;
	private int _speed;
	private physics.CollisionObject _colOb;
	private MotionTimer _mt;
//	private int _gravityPixels;

	/**
	 * Creates a new <code>StraightMotion</code> instance.
	 * 
	 * @param colOb
	 *            a <code>CollisionObject</code> value
	 */
	public StraightMotion(CollisionObject colOb) {

		_colOb = colOb;
		_speed = 100;
		_dx = 10;
		_dy = 0;
		_mt = new MotionTimer(_speed, this);

	}

	/**
	 * Sets the velocity of the motion
	 * 
	 * @param dx
	 *            an <code>int</code> value
	 * @param dy
	 *            an <code>int</code> value
	 * @param speed
	 *            an <code>int</code> value
	 */
	@Override
	public void setVelocity(int dx, int dy, int speed) {
		_dx = dx;
		_dy = dy;
		_speed = speed;
		_mt.setDelay(_speed);
	}

	/**
	 * Sets the DX of the motion
	 * 
	 * @param dx
	 *            an <code>int</code> value
	 * @param speed
	 *            an <code>int</code> value
	 */
	@Override
	public void setDX(int dx) {
		_dx = dx;
	}

	/**
	 * Sets the DY of the motion
	 * 
	 * @param dy
	 *            an <code>int</code> value
	 * @param speed
	 *            an <code>int</code> value
	 */
	@Override
	public void setDY(int dy) {
		_dy = dy;
	}

	/**
	 * Returns the speed of the motion
	 * 
	 * @return an <code>int</code> value
	 */
	@Override
	public int getSpeed() {
		return _speed;
	}

	/**
	 * Returns dx of the velocity
	 * 
	 * @return an <code>int</code> value
	 */
	@Override
	public int getDX() {
		return _dx;
	}

	/**
	 * Returns dy of the velocity
	 * 
	 * @return an <code>int</code> value
	 */
	@Override
	public int getDY() {
		return _dy;
	}

	/**
	 * Moves the object at intervals decided by the timer and checks for
	 * collisions
	 */
	@Override
	public void timerReact() {
		_colOb.getShape().setCenterLocation(
				new java.awt.Point(
						(_colOb.getShape().getCenterLocation().x + _dx),
						(_colOb.getShape().getCenterLocation().y + _dy)));
		_colOb.detectCollision();
	}

	/**
	 * Sets the MotionTimer for this motion
	 */
	public void setTimer(MotionTimer mt) {
		_mt = mt;
	}

	/**
	 * Starts the MotionTimer for this motion
	 */
	@Override
	public void start() {
		_mt.start();

	}

	/**
	 * Stops the MotionTimer for this object
	 */
	@Override
	public void stop() {
		_mt.stop();

	}

	/**
	 * A bounce for this motion
	 */
	@Override
	public void bounce(CollisionObject col) {
		if (col.getShape().getCenterLocation().x == _colOb.getShape()
				.getCenterLocation().x
				|| col.getShape().getCenterLocation().y == _colOb.getShape()
						.getCenterLocation().y
				|| this.getDX() == 0
				|| this.getDY() == 0) {
//			java.awt.Point p = _colOb.getShape().getLocation();
			int dx = this.getDX();
			int dy = this.getDY();
			dx = -dx;
			dy = -dy;
			this.setVelocity(dx, dy, this.getSpeed());
			_colOb.getShape().setCenterLocation(
					new java.awt.Point(
							(_colOb.getShape().getCenterLocation().x + dx),
							(_colOb.getShape().getCenterLocation().y + dy)));
		} else {
			/** change dx * */
			if ((this.getDX() < 0 && this.getDY() > 0)
					|| (this.getDX() > 0 && this.getDY() < 0)) {
				int dx = this.getDX();
				dx = -dx;
				this.setVelocity(dx, this.getDY(), this.getSpeed());
				_colOb.getShape().setCenterLocation(
						new java.awt.Point((_colOb.getShape()
								.getCenterLocation().x + this.getDX()), (_colOb
								.getShape().getCenterLocation().y + this
								.getDY())));
			} // end of if ()

			/** change dy * */
			else {

				if ((this.getDX() > 0 && this.getDY() > 0)
						|| (this.getDX() < 0 && this.getDY() < 0)) {
					int dy = this.getDY();
					dy = -dy;
					this.setVelocity(this.getDX(), dy, this.getSpeed());
					_colOb.getShape()
							.setCenterLocation(
									new java.awt.Point((_colOb.getShape()
											.getCenterLocation().x + this
											.getDX()), (_colOb.getShape()
											.getCenterLocation().y + this
											.getDY())));
				} // end of if ()
			} // end of else
		}// end of else

		this.stillCollide(col);
	}

	/**
	 * Check to see if the object with this motion and col are still colliding
	 * and if so move them apart
	 * 
	 * @param col
	 *            a <code>CollisionObject</code> value
	 */
	public void stillCollide(CollisionObject col) {

		while (_colOb.getShape().intersects(col.getShape())) {
			// System.out.println("still collide");
			if (this.getDX() > 0) {
				_colOb.getShape().setCenterLocation(
						new java.awt.Point(_colOb.getShape()
								.getCenterLocation().x - 2, _colOb.getShape()
								.getCenterLocation().y));
			} // end of if ()
			if (this.getDX() < 0) {
				_colOb.getShape().setCenterLocation(
						new java.awt.Point(_colOb.getShape()
								.getCenterLocation().x + 2, _colOb.getShape()
								.getCenterLocation().y));
			} // end of if ()
			if (this.getDY() < 0) {
				_colOb.getShape().setCenterLocation(
						new java.awt.Point(_colOb.getShape()
								.getCenterLocation().x, _colOb.getShape()
								.getCenterLocation().y + 2));
			} // end of if ()
			if (this.getDX() > 0) {
				_colOb.getShape().setCenterLocation(
						new java.awt.Point(_colOb.getShape()
								.getCenterLocation().x, _colOb.getShape()
								.getCenterLocation().y - 2));
			} // end of if ()
		} // end of while ()

	}

}// StraightMotion
