package utilities;

/**
 * 
 * A Class that is used for creating a new Color based on another one.
 *
 * @author <a href="mailto:bcrobboy@cse.buffalo.edu">Ben Robboy</a>
 * @author <a href="mailto:kozelsky@cse.buffalo.edu">Michael M Kozelsky</a>
 *
 * Created on: Oct 12, 2006
 */
public class ColorChanger {
	
	/**
	 * Gradually darkens a color.  If called repeatedly
	 * on the same color, it will eventually go to black.
	 * Written by Ben Robboy.
	 * 	 
	 * @param c a color to darken
	 * @return the color darkened slightly
	 */
	public static java.awt.Color darken(java.awt.Color c){
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();

        if (r>1)
                r-=2;   //Decrementing by 1 is too slow
        if (g>1)
                g-=2;
        if (b>1)
                b-=2;

        return new java.awt.Color(r,g,b);
	} 

}
