package utilities;


/**
 * Provides a way to play a sound through the computer's default 
 * sound hardware. WAV, AU, AIFF, and MIDI sound formats are all supported.
 * 
 * @author Mark Jensen 
 * <a href="mailto:mpjensen@cse.buffalo.edu">Mark P Jensen</a>
 *
 * Created on: Apr 2, 2007
 *
 */
public class Sound {

    /** The URL that stores the location of the sound */
    private java.net.URL _soundURL;

    /** The AudioClip that will actually be played */
    private java.applet.AudioClip _audioClip;

    /**
     * Create a <code>Sound</code> that will play the given file
     *
     * @param file the full path of the file of the sound to be played.
     */
    public Sound(String file) {
    	
		String urlFile = "";
		urlFile = file.replace("\\", "/");
		_soundURL = createURL("file:" + urlFile);
		_audioClip = java.applet.Applet.newAudioClip(_soundURL);
		//System.out.println(urlfile);
		
	}

    /**
     * Create a <code>Sound</code> from the given URL
     *
     * @param url the absolute URL of the sound to be played.
     */
    public Sound(java.net.URL url) {
    	_soundURL = url;
    	_audioClip = java.applet.Applet.newAudioClip(_soundURL);
    }

    
    /**
     * Starts playing this sound
     */
    public void play() {
    	_audioClip.play();
    }

    /**
     * Stops playing this sound
     */
    public void stop() {
    	_audioClip.stop();
    }
    
    /**
     * Starts playing this sound in a loop
     */
    public void loop() {
    	_audioClip.loop();
    }
    
    private java.net.URL createURL(String url) {
      try {
        return new java.net.URL(url);
      }
      catch(java.net.MalformedURLException e) {
        System.out.println(e);
      }
      return null;
    }
  		

}
