import greenfoot.*;

/**
 * LeftRightMover. This is the base class for the hero of our story. In addition to the standard Actor
 * methods, it provides the ability to move left and right.  Based on the Animal class in the
 * little-crab scenario (written by Michael Kolling).
 * 
 * @author Adrienne Decker
 * @version 1.0
 */
public class LeftRightMover extends Actor
{
    private static final int WALKING_SPEED = 10;
    
    /**
     * Constructor for LeftRightMover - nothing to do.
     */
    public LeftRightMover()
    {
    }

    /**
     * Act - empty method. Animals have no default action.
     */
    public void act()
    {
    }
    

    /**
     * Move forward in the current direction.
     */
    public void moveLeft()
    {   
        setLocation(getX() - WALKING_SPEED, getY());
    }

    public void moveRight()
    {
        setLocation(getX() + WALKING_SPEED, getY());
    }
    
    /**
     * Test if we are close to one of the edges of the world. Return true is we are.
     */
    public boolean atWorldEdge()
    {
        if(getX() < 20 || getX() > getWorld().getWidth() - 20)
            return true;
        if(getY() < 20 || getY() > getWorld().getHeight() - 20)
            return true;
        else
            return false;
    }
    
    
    /**
     * Return true if we can see an object of class 'clss' right where we are. 
     * False if there is no such object here.
     */
    public Actor getIntersectingFood(Class clss)
    {
        Actor actor = getOneObjectAtOffset(0, 0, clss);
        return actor;        
    }

}