import greenfoot.*;

/**
 * DownwardMover. This is the base class for all food. In addition to the standard Actor
 * methods, it provides the ability to move down.  Based on the Animal class in the
 * little-crab scenario (written by Michael Kolling).
 * 
 * @author Adrienne Decker
 * @version 1.0
 */
public class DownwardMover extends Actor
{
    private static final int WALKING_SPEED = 2;
    
    /**
     * Constructor for DownwardMover - nothing to do.
     */
    public DownwardMover()
    {
    }

    /**
     * Act - empty method. DownwardMovers have no default action.
     */
    public void act()
    {
    }
    

    /**
     * Move down (always).
     */
    public void move()
    {   
        setLocation(getX(), getY() + WALKING_SPEED);
    }

    
    /**
     * Test if we are close to one of the edges of the world. Return true is we are.
     */
    public boolean atBottom()
    {
        if(getY() > getWorld().getHeight() - 20)
            return true;
        else
            return false;
    }
    
    
    /**
     * Return true if we can see an object of class 'clss' right where we are. 
     * False if there is no such object here.
     */
    public boolean canSee(Class clss)
    {
        Actor actor = getOneObjectAtOffset(0, 0, clss);
        return actor != null;        
    }

}