package ora.jwsnut.chapter3.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

/**
 * SAAJ client that receives images from a web service.
 */
public class SAAJDemoClient {
    
    // The XML Schema namespace
    private static final String XMLSCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    
    // The XML Schema instance namespace
    private static final String XMLSCHEMA_INSTANCE_URI = 
                                        "http://www.w3.org/2001/XMLSchema-instance";

    // Namespace prefix for XML Schema
    private static final String XMLSCHEMA_PREFIX = "xsd";

    // Namespace prefix for XML Schema instance
    private static final String XMLSCHEMA_INSTANCE_PREFIX = "xsi";    
    
    // The namespace prefix used for SOAP encoding
    private static final String SOAP_ENC_PREFIX = "SOAP-ENC";
    
    // The URI used to qualify elements for this service
    private static final String SERVICE_URI = "urn:jwsnut.SAAJDemoservice";
    
    // The namespace prefix used in elements for this service
    private static final String SERVICE_PREFIX = "tns";
    
    // MessageFactory for replies from this service
    private static MessageFactory messageFactory;
     
    // SOAPFactory for message pieces
    private static SOAPFactory soapFactory;
    
    // SOAPConnection used to call the server
    private static SOAPConnection conn;
    
    // The name of the element used to request a image
    private static Name IMAGE_REQUEST_NAME;
    
    // The name of the element used to respond to a image request
    private static Name IMAGE_NAME;
  
    // The name of the attribute used to hold the image encoding
   // private static Name IMAGE_TYPE_ATTRIBUTE;
    
    // The name of the href attribute
    private static Name HREF_ATTRIBUTE;
    
    // Server address
    private static String serverAddress;
    
    // Debug required flag
    private static boolean debug;
      
    public static void main(String[] args) {
        // Ignore hostname verification failures
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });        
        
        if (args.length != 1) {
            usage();
        }
        serverAddress = args[0];
        
        // Determine whether debug messages are required
        //debug = System.getProperty("DEBUG_MESSAGE") != null;
	debug=true;
        try {        
            // Create all static data 
            messageFactory = MessageFactory.newInstance();
            soapFactory = SOAPFactory.newInstance();
            IMAGE_REQUEST_NAME = 
                        soapFactory.createName("ImageRequest", SERVICE_PREFIX, SERVICE_URI);
            IMAGE_NAME = soapFactory.createName("Image", SERVICE_PREFIX, SERVICE_URI);
          //  IMAGE_TYPE_ATTRIBUTE = soapFactory.createName("imageType", SERVICE_PREFIX, SERVICE_URI);
            HREF_ATTRIBUTE = soapFactory.createName("href");
           
            // Get a SOAPConnection        
            SOAPConnectionFactory connFactory = SOAPConnectionFactory.newInstance();
            conn = connFactory.createConnection();
            getImage();    
        } catch (Exception ex) {
            System.out.println(ex);
        }
    }
    
    public static void usage() {
        System.err.println("Usage: java SAAJDemoClient address");
        System.exit(1);
    }
    
    /**
     * Gets the image
     */
    private static void getImage() throws SOAPException, IOException {
	//System.out.println("INside getImages()");            
        // Build the message
        SOAPMessage message = messageFactory.createMessage();

        // Remove the message header
        SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
        envelope.getHeader().detachNode();

        // Set up the namespaces and the encoding style
        envelope.addNamespaceDeclaration(SERVICE_PREFIX, SERVICE_URI);
        envelope.addNamespaceDeclaration(SOAP_ENC_PREFIX, 
                                            SOAPConstants.URI_NS_SOAP_ENCODING);
        envelope.addNamespaceDeclaration(XMLSCHEMA_PREFIX, XMLSCHEMA_URI);
        envelope.addNamespaceDeclaration(XMLSCHEMA_INSTANCE_PREFIX, 
                                                        XMLSCHEMA_INSTANCE_URI);        
        envelope.setEncodingStyle(SOAPConstants.URI_NS_SOAP_ENCODING);

        // Add the element for the image request
        SOAPBody soapBody = envelope.getBody();
        SOAPBodyElement bodyElement = soapBody.addBodyElement(IMAGE_REQUEST_NAME);
        
        //bodyElement.addAttribute(IMAGE_TYPE_ATTRIBUTE, "image/gif");
        SOAPElement titleElement = bodyElement.addChildElement("item");
        titleElement.addTextNode("test.GIF");
	System.out.println("Prepared message:");            

        // Print the message.
        printMessage(message);
        
        SOAPMessage reply = conn.call(message, serverAddress);
        conn.close(); 
        // Print the reply
        //printMessage(reply);
        SOAPBody replyBody = reply.getSOAPPart().getEnvelope().getBody();
        Iterator iter = replyBody.getChildElements();
        if (iter.hasNext()) {
		Iterator attachIter = reply.getAttachments();
            	if (attachIter.hasNext()) {
                        AttachmentPart attach = (AttachmentPart)attachIter.next();
                        InputStream is=attach.getDataHandler().getInputStream();
                        FileOutputStream os =new FileOutputStream("ReceivedImage.gif");
                        byte[] buff = new byte[1024];
                        int read = 0;
                        while ((read = is.read(buff, 0, buff.length)) != -1) {
                                os.write(buff, 0, read);
                        }
                        os.flush();
                        os.close();
			System.out.println("Got the reply message.\nExtracted the bytes in the attachment and stored as ReceivedImage.gif"); 
             } 
        } else {
            throw new SOAPException("No Image element in returned message");
        }
    }
    
    /* -- Debug methods -- */
    private static void printMessage(SOAPMessage message) throws IOException, SOAPException {
        if (debug && message != null) {
            // Get the MIME headers and print them
            System.out.println("Headers:");
            if (message.saveRequired()) {
                message.saveChanges();
            }
            MimeHeaders headers = message.getMimeHeaders();
            printHeaders(headers);
            
            // Print the message itself
            System.out.println("\nMessage:");
            message.writeTo(System.out);
            System.out.println();
        }
    }
    
    private static void printHeaders(MimeHeaders headers) {
        if (debug) {
            printHeaders(headers.getAllHeaders());
        }
    }
    
    private static void printHeaders(Iterator iter) {
        if (debug) {
            while (iter.hasNext()) {
                MimeHeader header = (MimeHeader)iter.next();
                System.out.println("\t" + header.getName() + ": " + header.getValue());
            }
        }
    }
}
