/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.array;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.samples.ArraySample.ArraySamplePortType;
import org.globus.ogsa.samples.array.ResultField;
import org.globus.ogsa.samples.array.Tuple;

import java.rmi.RemoteException;

import java.util.Vector;


public class ArraySampleServiceImpl extends GridServiceImpl
    implements ArraySamplePortType {
    public ArraySampleServiceImpl() {
        super("Sample Array Service");
    }

    public Tuple next() throws RemoteException {
        Tuple tuple = new Tuple();
        Vector rows = new Vector();
        rows.add("Row1");
        rows.add("Row2");
        tuple.setRows(rows);

        ResultField[] field = new ResultField[2];
        field[0] = new ResultField();
        field[0].setName("Field1SampleName");
        field[0].setType("Field1SampleType");
        field[1] = new ResultField();
        field[1].setName("Field2SampleName");
        field[1].setType("Field2SampleType");
        tuple.setFields(field);

        return tuple;
    }
}
