/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.array;

import org.globus.ogsa.samples.ArraySample.ArraySamplePortType;
import org.globus.ogsa.samples.ArraySample.ArraySampleServiceLocator;
import org.globus.ogsa.samples.array.ResultField;
import org.globus.ogsa.samples.array.Tuple;

import java.net.URL;

import java.util.Enumeration;
import java.util.Vector;


public class GetResultFields {
    public static void main(String[] args) {
        try {
            ArraySampleServiceLocator locator = new ArraySampleServiceLocator();
            ArraySamplePortType service =
                locator.getArraySampleService(new URL(args[0]));
            Tuple tuple = service.next();
            ResultField[] fields = tuple.getFields();

            for (int i = 0; i < fields.length; i++) {
                System.out.println(
                    "Field name: " + fields[i].getName() + " type: " +
                    fields[i].getType()
                );
            }

            Vector rows = tuple.getRows();

            for (Enumeration enum = rows.elements(); enum.hasMoreElements();) {
                System.out.println("Row: " + (String) enum.nextElement());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
