/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.basic;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.samples.counter.CounterPortType;
import org.globus.ogsa.samples.counter.encoded.types.CounterBatchStatusType;
import org.globus.ogsa.samples.counter.encoded.types.CounterBatchType;

import org.apache.axis.MessageContext;

import java.rmi.RemoteException;


public class CounterImpl extends GridServiceImpl implements CounterPortType {
    protected int val = 0;

    public CounterImpl() {
        super("Sample Counter");
    }

    public CounterImpl(String name) {
        super(name);
    }

    public void postCreate(GridContext context) throws GridServiceException {
        super.postCreate(context);

        String path =
            (String) context.getMessageContext().getProperty(
                ServiceProperties.INVOCATION_ID
            );

        if ((path != null) && path.equals("testException")) {
            throw new GridServiceException("Test Exception");
        }
    }

    public int add(int val) throws RemoteException {
        this.val = this.val + val;

        return this.val;
    }

    public int subtract(int val) throws RemoteException {
        this.val = this.val - val;

        return this.val;
    }

    public int getValue() throws RemoteException {
        return this.val;
    }

    public CounterBatchStatusType submitBatch(CounterBatchType[] batch)
        throws RemoteException {
        CounterBatchStatusType status = new CounterBatchStatusType();
        status.setBeforeValue(this.val);

        for (int i = 0; i < batch.length; i++) {
            if (batch[i].getOperation().equalsIgnoreCase("add")) {
                add(batch[i].getVal());
            } else if (batch[i].getOperation().equalsIgnoreCase("subtract")) {
                subtract(batch[i].getVal());
            }
        }

        status.setAfterValue(this.val);

        return status;
    }
}
